/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.schema.DocumentGraphValidator;
import com.yahoo.schema.DocumentModelBuilder;
import com.yahoo.schema.DocumentReferenceResolver;
import com.yahoo.schema.ImportedFieldsEnumerator;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.SDDocumentTypeOrderer;
import com.yahoo.schema.Schema;
import com.yahoo.schema.TemporarySDTypeResolver;
import com.yahoo.schema.derived.SearchOrderer;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.processing.Processing;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Application {
    private final ApplicationPackage applicationPackage;
    private final Map<String, Schema> schemas;
    private final DocumentModel documentModel;

    public Application(ApplicationPackage applicationPackage, List<Schema> schemas, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, ModelContext.Properties properties, boolean documentsOnly, boolean validate, Set<Class<? extends Processor>> processorsToSkip, DeployLogger logger) {
        this.applicationPackage = applicationPackage;
        LinkedHashMap<String, Schema> schemaMap = new LinkedHashMap<String, Schema>();
        for (Schema schema2 : schemas) {
            if (schemaMap.containsKey(schema2.getName())) {
                throw new IllegalArgumentException("Duplicate schema '" + schema2.getName() + "' in " + this);
            }
            schemaMap.put(schema2.getName(), schema2);
        }
        this.schemas = Collections.unmodifiableMap(schemaMap);
        schemas.forEach(schema -> schema.setOwner(this));
        if (validate) {
            schemas.forEach(schema -> schema.validate(logger));
        }
        new TemporarySDTypeResolver(schemas, logger).process();
        ArrayList<SDDocumentType> sdocs = new ArrayList<SDDocumentType>();
        sdocs.add(SDDocumentType.VESPA_DOCUMENT);
        for (Schema schema3 : schemas) {
            if (!schema3.hasDocument()) continue;
            sdocs.add(schema3.getDocument());
        }
        SDDocumentTypeOrderer sDDocumentTypeOrderer = new SDDocumentTypeOrderer(sdocs, logger);
        sDDocumentTypeOrderer.process();
        DocumentReferenceResolver resolver = new DocumentReferenceResolver(schemas);
        sdocs.forEach(resolver::resolveReferences);
        sdocs.forEach(resolver::resolveInheritedReferences);
        ImportedFieldsEnumerator importedFieldsEnumerator = new ImportedFieldsEnumerator(schemas);
        sdocs.forEach(importedFieldsEnumerator::enumerateImportedFields);
        if (validate) {
            new DocumentGraphValidator().validateDocumentGraph(sdocs);
        }
        ArrayList<Schema> schemasSomewhatOrdered = new ArrayList<Schema>(schemas);
        for (Schema schema4 : new SearchOrderer().order(schemasSomewhatOrdered)) {
            new Processing(properties).process(schema4, logger, rankProfileRegistry, queryProfiles, validate, documentsOnly, processorsToSkip);
        }
        this.documentModel = new DocumentModelBuilder().build(schemasSomewhatOrdered);
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Map<String, Schema> schemas() {
        return this.schemas;
    }

    public DocumentModel documentModel() {
        return this.documentModel;
    }

    public String toString() {
        return "application " + this.applicationPackage.getApplicationId();
    }
}

