/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.model.search.SearchCluster;

public class StreamingSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
RankProfilesConfig.Producer,
VsmsummaryConfig.Producer,
VsmfieldsConfig.Producer,
SummarymapConfig.Producer,
SummaryConfig.Producer {
    private final String storageRouteSpec;
    private final AttributesProducer attributesConfig;
    private final String docTypeName;
    private DerivedConfiguration schemaConfig = null;

    public StreamingSearchCluster(AbstractConfigProducer<SearchCluster> parent, String clusterName, int index, String docTypeName, String storageRouteSpec) {
        super(parent, clusterName, index);
        this.attributesConfig = new AttributesProducer(parent, docTypeName);
        this.docTypeName = docTypeName;
        this.storageRouteSpec = storageRouteSpec;
    }

    public final String getDocumentDBConfigId() {
        return this.attributesConfig.getConfigId();
    }

    @Override
    protected SearchCluster.IndexingMode getIndexingMode() {
        return SearchCluster.IndexingMode.STREAMING;
    }

    public final String getStorageRouteSpec() {
        return this.storageRouteSpec;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    @Override
    public int getRowBits() {
        return 0;
    }

    @Override
    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
        docDb.name(this.schemaConfig.getSchema().getName());
        Summaries prod = this.schemaConfig.getSummaries();
        this.convertSummaryConfig(prod, null, docDb);
        this.addRankProfilesConfig(this.schemaConfig.getSchema().getName(), docDb);
        builder.documentdb(docDb);
    }

    @Override
    public void deriveFromSchemas(DeployState deployState) {
        if (this.schemas().isEmpty()) {
            return;
        }
        if (this.schemas().size() > 1) {
            throw new IllegalArgumentException("Only a single schema is supported, got " + this.schemas().size());
        }
        Schema schema = this.schemas().values().stream().findAny().get().fullSchema();
        if (!schema.getName().equals(this.docTypeName)) {
            throw new IllegalArgumentException("Document type name '" + this.docTypeName + "' must be the same as the schema name '" + schema.getName() + "'");
        }
        this.schemaConfig = new DerivedConfiguration(schema, deployState);
    }

    @Override
    public DerivedConfiguration getSchemaConfig() {
        return this.schemaConfig;
    }

    @Override
    public void defaultDocumentsConfig() {
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        if (this.getSchemaConfig() != null) {
            this.getSchemaConfig().getConfig(builder);
        }
    }

    public void getConfig(VsmsummaryConfig.Builder builder) {
        if (this.getSchemaConfig() != null && this.getSchemaConfig().getVsmSummary() != null) {
            this.getSchemaConfig().getVsmSummary().getConfig(builder);
        }
    }

    public void getConfig(VsmfieldsConfig.Builder builder) {
        if (this.getSchemaConfig() != null && this.getSchemaConfig().getVsmFields() != null) {
            this.getSchemaConfig().getVsmFields().getConfig(builder);
        }
    }

    public void getConfig(SummarymapConfig.Builder builder) {
        if (this.getSchemaConfig() != null && this.getSchemaConfig().getSummaryMap() != null) {
            this.getSchemaConfig().getSummaryMap().getConfig(builder);
        }
    }

    public void getConfig(SummaryConfig.Builder builder) {
        if (this.getSchemaConfig() != null && this.getSchemaConfig().getSummaries() != null) {
            this.getSchemaConfig().getSummaries().getConfig(builder);
        }
    }

    private class AttributesProducer
    extends AbstractConfigProducer<AttributesProducer>
    implements AttributesConfig.Producer {
        AttributesProducer(AbstractConfigProducer<?> parent, String docType) {
            super(parent, docType);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            if (StreamingSearchCluster.this.getSchemaConfig() != null) {
                StreamingSearchCluster.this.getSchemaConfig().getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
            }
        }
    }
}

