/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.ml;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlFunction;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import com.google.common.collect.ImmutableMap;
import com.yahoo.collections.Pair;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.vespa.model.ml.FeatureArguments;
import com.yahoo.vespa.model.ml.ModelName;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConvertedModel {
    private final ModelName modelName;
    private final String modelDescription;
    private final ImmutableMap<String, ExpressionFunction> expressions;
    private final Optional<ImportedMlModel> sourceModel;

    private ConvertedModel(ModelName modelName, String modelDescription, Map<String, ExpressionFunction> expressions, Optional<ImportedMlModel> sourceModel) {
        this.modelName = modelName;
        this.modelDescription = modelDescription;
        this.expressions = ImmutableMap.copyOf(expressions);
        this.sourceModel = sourceModel;
    }

    public static ConvertedModel fromSourceOrStore(Path modelPath, boolean pathIsFile, RankProfileTransformContext context) {
        ApplicationPackage applicationPackage = context.rankProfile().applicationPackage();
        ImportedMlModel sourceModel = context.importedModels().get(ConvertedModel.sourceModelFile(applicationPackage, modelPath));
        ModelName modelName = new ModelName(context.rankProfile().name(), modelPath, pathIsFile);
        if (sourceModel == null && !new ModelStore(applicationPackage, modelName).exists()) {
            throw new IllegalArgumentException("No model '" + modelPath + "' is available. Available models: " + context.importedModels().all().stream().map(ImportedMlModel::source).collect(Collectors.joining(", ")));
        }
        if (sourceModel != null) {
            if (!sourceModel.isNative()) {
                sourceModel = sourceModel.asNative();
            }
            return ConvertedModel.fromSource(applicationPackage, modelName, modelPath.toString(), context.rankProfile(), context.queryProfiles(), sourceModel);
        }
        return ConvertedModel.fromStore(applicationPackage, modelName, modelPath.toString(), context.rankProfile());
    }

    public static ConvertedModel fromSource(ApplicationPackage applicationPackage, ModelName modelName, String modelDescription, RankProfile rankProfile, QueryProfileRegistry queryProfileRegistry, ImportedMlModel importedModel) {
        try {
            ModelStore modelStore = new ModelStore(applicationPackage, modelName);
            return new ConvertedModel(modelName, modelDescription, ConvertedModel.convertAndStore(importedModel, rankProfile, queryProfileRegistry, modelStore), Optional.of(importedModel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("In " + rankProfile + ": Could not create model '" + modelName + " (" + modelDescription + ")", e);
        }
    }

    public static ConvertedModel fromStore(ApplicationPackage applicationPackage, ModelName modelName, String modelDescription, RankProfile rankProfile) {
        try {
            ModelStore modelStore = new ModelStore(applicationPackage, modelName);
            return new ConvertedModel(modelName, modelDescription, ConvertedModel.convertStored(modelStore, rankProfile), Optional.empty());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("In " + rankProfile + ": Could not create model '" + modelName + " (" + modelDescription + ")", e);
        }
    }

    public Map<String, ExpressionFunction> expressions() {
        return this.expressions;
    }

    public ExpressionNode expression(FeatureArguments arguments, RankProfileTransformContext context) {
        ExpressionFunction expression = this.selectExpression(arguments);
        if (this.sourceModel.isPresent() && context != null) {
            ConvertedModel.verifyInputs(expression.getBody(), this.sourceModel.get(), context.rankProfile(), context.queryProfiles());
        }
        return expression.getBody().getRoot();
    }

    private ExpressionFunction selectExpression(FeatureArguments arguments) {
        if (this.expressions.isEmpty()) {
            throw new IllegalArgumentException("No expressions available in " + this);
        }
        ExpressionFunction expression = (ExpressionFunction)this.expressions.get((Object)arguments.toName());
        if (expression != null) {
            return expression;
        }
        expression = (ExpressionFunction)this.expressions.get((Object)("default." + arguments.toName()));
        if (expression != null) {
            return expression;
        }
        if (arguments.signature().isEmpty()) {
            if (this.expressions.size() > 1) {
                throw new IllegalArgumentException("Multiple candidate expressions " + this.missingExpressionMessageSuffix());
            }
            return (ExpressionFunction)this.expressions.values().iterator().next();
        }
        if (arguments.output().isEmpty()) {
            List entriesWithTheRightPrefix = this.expressions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(arguments.signature().get() + ".")).collect(Collectors.toList());
            if (entriesWithTheRightPrefix.size() < 1) {
                throw new IllegalArgumentException("No expressions named '" + arguments.signature().get() + this.missingExpressionMessageSuffix());
            }
            if (entriesWithTheRightPrefix.size() > 1) {
                throw new IllegalArgumentException("Multiple candidate expression named '" + arguments.signature().get() + this.missingExpressionMessageSuffix());
            }
            return (ExpressionFunction)((Map.Entry)entriesWithTheRightPrefix.get(0)).getValue();
        }
        throw new IllegalArgumentException("No expression '" + arguments.toName() + this.missingExpressionMessageSuffix());
    }

    private String missingExpressionMessageSuffix() {
        return "' in model '" + this.modelDescription + "'. Available expressions: " + this.expressions.keySet().stream().collect(Collectors.joining(", "));
    }

    private static Map<String, ExpressionFunction> convertAndStore(ImportedMlModel model, RankProfile profile, QueryProfileRegistry queryProfiles, ModelStore store) {
        HashSet<String> constantsReplacedByFunctions = new HashSet<String>();
        model.smallConstants().forEach((k, v) -> ConvertedModel.transformSmallConstant(store, profile, k, v));
        model.largeConstants().forEach((k, v) -> ConvertedModel.transformLargeConstant(store, profile, queryProfiles, constantsReplacedByFunctions, k, v));
        ConvertedModel.addGeneratedFunctions(model, profile);
        HashMap<String, ExpressionFunction> expressions = new HashMap<String, ExpressionFunction>();
        for (ImportedMlFunction outputFunction : model.outputExpressions()) {
            ExpressionFunction expression = ConvertedModel.asExpressionFunction(outputFunction);
            for (Map.Entry input : expression.argumentTypes().entrySet()) {
                Reference name = Reference.fromIdentifier((String)((String)input.getKey()));
                profile.addInput(name, new RankProfile.Input(name, (TensorType)input.getValue(), Optional.empty()));
            }
            ConvertedModel.addExpression(expression, expression.getName(), constantsReplacedByFunctions, store, profile, queryProfiles, expressions);
        }
        model.functions().forEach((k, v) -> ConvertedModel.transformGeneratedFunction(store, constantsReplacedByFunctions, k, profile.getFunctions().get(k).function().getBody()));
        return expressions;
    }

    private static ExpressionFunction asExpressionFunction(ImportedMlFunction function) {
        try {
            HashMap<String, TensorType> argumentTypes = new HashMap<String, TensorType>();
            for (Map.Entry entry : function.argumentTypes().entrySet()) {
                argumentTypes.put((String)entry.getKey(), TensorType.fromSpec((String)((String)entry.getValue())));
            }
            return new ExpressionFunction(function.name(), function.arguments(), new RankingExpression(function.expression()), argumentTypes, function.returnType().map(TensorType::fromSpec));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Got an illegal argument from importing " + function.name(), e);
        }
    }

    private static void addExpression(ExpressionFunction expression, String expressionName, Set<String> constantsReplacedByFunctions, ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles, Map<String, ExpressionFunction> expressions) {
        TensorType type;
        if ((expression = expression.withBody(ConvertedModel.replaceConstantsByFunctions(expression.getBody(), constantsReplacedByFunctions))).returnType().isEmpty() && (type = expression.getBody().type((TypeContext)profile.typeContext(queryProfiles))) != null) {
            expression = expression.withReturnType(type);
        }
        store.writeExpression(expressionName, expression);
        expressions.put(expressionName, expression);
    }

    private static Map<String, ExpressionFunction> convertStored(ModelStore store, RankProfile profile) {
        for (Pair<String, Tensor> pair : store.readSmallConstants()) {
            Reference name = FeatureNames.asConstantFeature((String)pair.getFirst());
            profile.add(new RankProfile.Constant(name, (Tensor)pair.getSecond()));
        }
        for (RankProfile.Constant constant : store.readLargeConstants()) {
            profile.add(constant);
        }
        for (Pair pair : store.readFunctions()) {
            ConvertedModel.addGeneratedFunctionToProfile(profile, (String)pair.getFirst(), (RankingExpression)pair.getSecond());
        }
        HashMap<String, ExpressionFunction> expressions = new HashMap<String, ExpressionFunction>();
        for (Pair<String, ExpressionFunction> output : store.readExpressions()) {
            String name = (String)output.getFirst();
            ExpressionFunction expression = (ExpressionFunction)output.getSecond();
            for (Map.Entry input : expression.argumentTypes().entrySet()) {
                Reference inputName = Reference.fromIdentifier((String)((String)input.getKey()));
                profile.addInput(inputName, new RankProfile.Input(inputName, (TensorType)input.getValue(), Optional.empty()));
            }
            TensorType type = expression.getBody().type((TypeContext)profile.typeContext());
            if (type != null) {
                expression = expression.withReturnType(type);
            }
            expressions.put(name, expression);
        }
        return expressions;
    }

    private static void transformSmallConstant(ModelStore store, RankProfile profile, String constantName, String constantValueString) {
        Tensor constantValue = Tensor.from((String)constantValueString);
        store.writeSmallConstant(constantName, constantValue);
        Reference name = FeatureNames.asConstantFeature(constantName);
        profile.add(new RankProfile.Constant(name, constantValue));
    }

    private static void transformLargeConstant(ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles, Set<String> constantsReplacedByFunctions, String constantName, String constantValueString) {
        Tensor constantValue = Tensor.from((String)constantValueString);
        RankProfile.RankingExpressionFunction rankingExpressionFunctionOverridingConstant = profile.getFunctions().get(constantName);
        if (rankingExpressionFunctionOverridingConstant != null) {
            TensorType functionType = rankingExpressionFunctionOverridingConstant.function().getBody().type((TypeContext)profile.typeContext(queryProfiles));
            if (!constantValue.type().isAssignableTo(functionType)) {
                throw new IllegalArgumentException("Function '" + constantName + "' replaces the constant with this name. " + ConvertedModel.typeMismatchExplanation(constantValue.type(), functionType));
            }
            constantsReplacedByFunctions.add(constantName);
        } else {
            Reference constantReference = FeatureNames.asConstantFeature(constantName);
            if (!profile.constants().containsKey(constantReference)) {
                Path constantPath = store.writeLargeConstant(constantName, constantValue);
                profile.add(new RankProfile.Constant(constantReference, constantValue.type(), constantPath.toString()));
            }
        }
    }

    private static void transformGeneratedFunction(ModelStore store, Set<String> constantsReplacedByFunctions, String functionName, RankingExpression expression) {
        expression = ConvertedModel.replaceConstantsByFunctions(expression, constantsReplacedByFunctions);
        store.writeFunction(functionName, expression);
    }

    private static void addGeneratedFunctionToProfile(RankProfile profile, String functionName, RankingExpression expression) {
        if (profile.getFunctions().containsKey(functionName)) {
            if (!profile.getFunctions().get(functionName).function().getBody().equals((Object)expression)) {
                throw new IllegalArgumentException("Generated function '" + functionName + "' already exists in " + profile + " - with a different definition: Has\n" + profile.getFunctions().get(functionName).function().getBody() + "\nwant to add " + expression + "\n");
            }
            return;
        }
        ExpressionFunction function = new ExpressionFunction(functionName, expression);
        profile.addFunction(function, false);
    }

    private static void verifyInputs(RankingExpression expression, ImportedMlModel model, RankProfile profile, QueryProfileRegistry queryProfiles) {
        HashSet<String> functionNames = new HashSet<String>();
        ConvertedModel.addFunctionNamesIn(expression.getRoot(), functionNames, model);
        for (String functionName : functionNames) {
            Optional<TensorType> requiredType = model.inputTypeSpec(functionName).map(TensorType::fromSpec);
            if (requiredType.isEmpty()) continue;
            RankProfile.RankingExpressionFunction rankingExpressionFunction = profile.getFunctions().get(functionName);
            if (rankingExpressionFunction == null) {
                throw new IllegalArgumentException("Model refers input '" + functionName + "' of type " + requiredType.get() + " but this function is not present in " + profile);
            }
            TensorType actualType = rankingExpressionFunction.function().getBody().getRoot().type((TypeContext)profile.typeContext(queryProfiles));
            if (actualType == null) {
                throw new IllegalArgumentException("Model refers input '" + functionName + "' of type " + requiredType.get() + " which must be produced by a function in the rank profile, but this function references a feature which is not declared");
            }
            if (actualType.isAssignableTo(requiredType.get())) continue;
            throw new IllegalArgumentException("Model refers input '" + functionName + "'. " + ConvertedModel.typeMismatchExplanation(requiredType.get(), actualType));
        }
    }

    private static String typeMismatchExplanation(TensorType requiredType, TensorType actualType) {
        return "The required type of this is " + requiredType + ", but this function returns " + actualType + (actualType.rank() == 0 ? ". This is often due to missing declaration of query tensor features in query profile types - see the documentation." : "");
    }

    private static void addGeneratedFunctions(ImportedMlModel model, RankProfile profile) {
        model.functions().forEach((k, v) -> ConvertedModel.addGeneratedFunctionToProfile(profile, k, RankingExpression.from((String)v)));
    }

    private static RankingExpression replaceConstantsByFunctions(RankingExpression expression, Set<String> constantsReplacedByFunctions) {
        if (constantsReplacedByFunctions.isEmpty()) {
            return expression;
        }
        return new RankingExpression(expression.getName(), ConvertedModel.replaceConstantsByFunctions(expression.getRoot(), constantsReplacedByFunctions));
    }

    private static ExpressionNode replaceConstantsByFunctions(ExpressionNode node, Set<String> constantsReplacedByFunctions) {
        String argument;
        Reference reference;
        if (node instanceof ReferenceNode && FeatureNames.isSimpleFeature(reference = ((ReferenceNode)node).reference()) && reference.name().equals("constant") && constantsReplacedByFunctions.contains(argument = (String)reference.simpleArgument().get())) {
            return new ReferenceNode(argument);
        }
        if (node instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)node;
            return composite.setChildren(composite.children().stream().map(child -> ConvertedModel.replaceConstantsByFunctions(child, constantsReplacedByFunctions)).collect(Collectors.toList()));
        }
        return node;
    }

    private static void addFunctionNamesIn(ExpressionNode node, Set<String> names, ImportedMlModel model) {
        if (node instanceof ReferenceNode) {
            ReferenceNode referenceNode = (ReferenceNode)node;
            if (referenceNode.getOutput() == null && names.add(referenceNode.getName()) && model.functions().containsKey(referenceNode.getName())) {
                ConvertedModel.addFunctionNamesIn(RankingExpression.from((String)((String)model.functions().get(referenceNode.getName()))).getRoot(), names, model);
            }
        } else if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                ConvertedModel.addFunctionNamesIn(child, names, model);
            }
        }
    }

    public String toString() {
        return "model '" + this.modelName + "'";
    }

    public static File sourceModelFile(ApplicationPackage application, Path sourceModelPath) {
        return application.getFileReference(ApplicationPackage.MODELS_DIR.append(sourceModelPath));
    }

    static class ModelStore {
        private final ApplicationPackage application;
        private final ModelFiles modelFiles;

        ModelStore(ApplicationPackage application, ModelName modelName) {
            this.application = application;
            this.modelFiles = new ModelFiles(modelName);
        }

        public boolean exists() {
            return this.application.getFile(this.modelFiles.storedModelReplicatedPath()).exists();
        }

        void writeExpression(String name, ExpressionFunction expression) {
            StringBuilder b = new StringBuilder(expression.getBody().getRoot().toString());
            for (Map.Entry input : expression.argumentTypes().entrySet()) {
                b.append('\n').append((String)input.getKey()).append('\t').append(input.getValue());
            }
            this.application.getFile(this.modelFiles.expressionPath(name)).writeFile((Reader)new StringReader(b.toString()));
        }

        List<Pair<String, ExpressionFunction>> readExpressions() {
            ArrayList<Pair<String, ExpressionFunction>> expressions = new ArrayList<Pair<String, ExpressionFunction>>();
            ApplicationFile expressionPath = this.application.getFile(this.modelFiles.expressionsPath());
            if (!expressionPath.exists() || !expressionPath.isDirectory()) {
                return Collections.emptyList();
            }
            for (ApplicationFile expressionFile : expressionPath.listFiles()) {
                try (BufferedReader reader = new BufferedReader(expressionFile.createReader());){
                    String name = expressionFile.getPath().getName();
                    expressions.add((Pair<String, ExpressionFunction>)new Pair((Object)name, (Object)this.readExpression(name, reader)));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed reading " + expressionFile.getPath(), e);
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Invalid stored expression in " + expressionFile, e);
                }
            }
            return expressions;
        }

        private ExpressionFunction readExpression(String name, BufferedReader reader) throws IOException, ParseException {
            String line;
            RankingExpression expression = new RankingExpression(name, reader.readLine());
            LinkedHashMap<String, TensorType> inputs = new LinkedHashMap<String, TensorType>();
            while (null != (line = reader.readLine())) {
                String[] parts = line.split("\t");
                inputs.put(parts[0], TensorType.fromSpec((String)parts[1]));
            }
            return new ExpressionFunction(name, new ArrayList(inputs.keySet()), expression, inputs, Optional.empty());
        }

        public void writeFunction(String name, RankingExpression expression) {
            this.application.getFile(this.modelFiles.functionsPath()).appendFile(name + "\t" + expression.getRoot().toString() + "\n");
        }

        List<Pair<String, RankingExpression>> readFunctions() {
            ArrayList<Pair<String, RankingExpression>> arrayList;
            ApplicationFile file = this.application.getFile(this.modelFiles.functionsPath());
            if (!file.exists()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<String, RankingExpression>> functions = new ArrayList<Pair<String, RankingExpression>>();
            BufferedReader reader = new BufferedReader(file.createReader());
            try {
                String line;
                while (null != (line = reader.readLine())) {
                    String[] parts = line.split("\t");
                    String name = parts[0];
                    try {
                        RankingExpression expression = new RankingExpression(parts[0], parts[1]);
                        functions.add((Pair<String, RankingExpression>)new Pair((Object)name, (Object)expression));
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException("Could not parse " + name, e);
                    }
                }
                arrayList = functions;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
            return arrayList;
        }

        List<RankProfile.Constant> readLargeConstants() {
            try {
                ArrayList<RankProfile.Constant> constants = new ArrayList<RankProfile.Constant>();
                for (ApplicationFile constantFile : this.application.getFile(this.modelFiles.largeConstantsInfoPath()).listFiles()) {
                    String[] parts = IOUtils.readAll((Reader)constantFile.createReader()).split(":");
                    constants.add(new RankProfile.Constant(FeatureNames.asConstantFeature(parts[0]), TensorType.fromSpec((String)parts[1]), parts[2]));
                }
                return constants;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        Path writeLargeConstant(String name, Tensor constant) {
            Path constantsPath = this.modelFiles.largeConstantsContentPath();
            Path constantPath = constantsPath.append(name + ".tbf");
            this.application.getFile(this.modelFiles.largeConstantsInfoPath().append(name + ".constant")).writeFile((Reader)new StringReader(name + ":" + constant.type() + ":" + this.correct(constantPath)));
            if (this.modelFiles.modelName.isGlobal() || !this.application.getFileReference(constantPath).exists()) {
                this.createIfNeeded(constantsPath);
                IOUtils.writeFile((File)this.application.getFileReference(constantPath), (byte[])TypedBinaryFormat.encode((Tensor)constant));
            }
            return this.correct(constantPath);
        }

        private List<Pair<String, Tensor>> readSmallConstants() {
            try {
                String line;
                ApplicationFile file = this.application.getFile(this.modelFiles.smallConstantsPath());
                if (!file.exists()) {
                    return Collections.emptyList();
                }
                ArrayList<Pair<String, Tensor>> constants = new ArrayList<Pair<String, Tensor>>();
                BufferedReader reader = new BufferedReader(file.createReader());
                while (null != (line = reader.readLine())) {
                    String[] parts = line.split("\t");
                    String name = parts[0];
                    TensorType type = TensorType.fromSpec((String)parts[1]);
                    Tensor tensor = Tensor.from((TensorType)type, (String)parts[2]);
                    constants.add((Pair<String, Tensor>)new Pair((Object)name, (Object)tensor));
                }
                return constants;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void writeSmallConstant(String name, Tensor constant) {
            this.application.getFile(this.modelFiles.smallConstantsPath()).appendFile(name + "\t" + constant.type().toString() + "\t" + constant + "\n");
        }

        private Path correct(Path path) {
            if (this.application.getFileReference(Path.fromString((String)"")).getAbsolutePath().endsWith(".preprocessed") && !path.elements().contains(".preprocessed")) {
                return Path.fromString((String)".preprocessed").append(path);
            }
            return path;
        }

        private void createIfNeeded(Path path) {
            File dir = this.application.getFileReference(path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalStateException("Could not create " + dir);
            }
        }
    }

    static class ModelFiles {
        ModelName modelName;

        public ModelFiles(ModelName modelName) {
            this.modelName = modelName;
        }

        public Path storedModelReplicatedPath() {
            return ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR.append(this.modelName.fullName());
        }

        public Path storedGlobalModelPath() {
            return ApplicationPackage.MODELS_GENERATED_DIR.append(this.modelName.localName());
        }

        public Path expressionPath(String name) {
            return this.expressionsPath().append(name);
        }

        public Path expressionsPath() {
            return this.storedModelReplicatedPath().append("expressions");
        }

        public Path smallConstantsPath() {
            return this.storedModelReplicatedPath().append("constants.txt");
        }

        public Path largeConstantsContentPath() {
            return this.storedGlobalModelPath().append("constants");
        }

        public Path largeConstantsInfoPath() {
            return this.storedModelReplicatedPath().append("constants");
        }

        public Path functionsPath() {
            return this.storedModelReplicatedPath().append("functions.txt");
        }
    }
}

