/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Iterator;

public class LiteralBoost
extends Processor {
    public LiteralBoost(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.checkRankModifierRankType(this.schema);
        this.addLiteralBoostsToFields(this.schema);
        this.reduceFieldLiteralBoosts(this.schema);
    }

    private void checkRankModifierRankType(Schema schema) {
        for (SDField field : schema.allConcreteFields()) {
            if (field.getLiteralBoost() > -1 || !field.getRanking().isLiteral()) continue;
            field.setLiteralBoost(100);
        }
    }

    private void addLiteralBoostsToFields(Schema schema) {
        Iterator<RankProfile.RankSetting> i = this.matchingRankSettingsIterator(schema, RankProfile.RankSetting.Type.LITERALBOOST);
        while (i.hasNext()) {
            RankProfile.RankSetting setting = i.next();
            SDField field = schema.getConcreteField(setting.getFieldName());
            if (field == null || field.getLiteralBoost() >= 0) continue;
            field.setLiteralBoost(0);
        }
    }

    private void reduceFieldLiteralBoosts(Schema schema) {
        for (SDField field : schema.allConcreteFields()) {
            if (field.getLiteralBoost() < 0) continue;
            this.reduceFieldLiteralBoost(field, schema);
        }
    }

    private void reduceFieldLiteralBoost(SDField field, Schema schema) {
        SDField literalField = this.addField(schema, field, "literal", "{ input " + field.getName() + " | tokenize | index " + field.getName() + "_literal; }", "literal-boost");
        literalField.setWeight(field.getWeight() + field.getLiteralBoost());
    }
}

