/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.GeoPos;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class CreatePositionZCurve
extends Processor {
    private final SDDocumentType repo;
    private boolean useV8GeoPositions = false;

    public CreatePositionZCurve(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
        this.repo = schema.getDocument();
    }

    @Override
    public void process(boolean validate, boolean documentsOnly, ModelContext.Properties properties) {
        this.useV8GeoPositions = properties.featureFlags().useV8GeoPositions();
        this.process(validate, documentsOnly);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            SDField posY;
            DataType fieldType = field.getDataType();
            if (!CreatePositionZCurve.isSupportedPositionType(fieldType)) continue;
            if (validate && field.doesIndexing()) {
                this.fail(this.schema, field, "Indexing of data type '" + fieldType.getName() + "' is not supported, replace 'index' statement with 'attribute'.");
            }
            if (!field.doesAttributing()) continue;
            boolean doesSummary = field.doesSummarying();
            String fieldName = field.getName();
            field.getAttributes().remove(fieldName);
            String zName = PositionDataType.getZCurveFieldName((String)fieldName);
            SDField zCurveField = this.createZCurveField(field, zName, validate);
            this.schema.addExtraField(zCurveField);
            this.schema.fieldSets().addBuiltInFieldSetItem("[internal]", zCurveField.getName());
            Set<String> summaryTo = this.removeSummaryTo(field);
            if (!this.useV8GeoPositions) {
                this.ensureCompatibleSummary(field, zName, PositionDataType.getPositionSummaryFieldName((String)fieldName), (DataType)DataType.getArray((DataType)DataType.STRING), SummaryTransform.POSITIONS, summaryTo, validate);
                this.ensureCompatibleSummary(field, zName, PositionDataType.getDistanceSummaryFieldName((String)fieldName), (DataType)DataType.INT, SummaryTransform.DISTANCE, summaryTo, validate);
            }
            field.setIndexingScript(null);
            SDField posX = field.getStructField("x");
            if (posX != null) {
                posX.setIndexingScript(null);
            }
            if ((posY = field.getStructField("y")) != null) {
                posY.setIndexingScript(null);
            }
            if (!doesSummary) continue;
            this.ensureCompatibleSummary(field, zName, field.getName(), field.getDataType(), SummaryTransform.GEOPOS, summaryTo, validate);
        }
    }

    private SDField createZCurveField(SDField inputField, String fieldName, boolean validate) {
        if (validate && this.schema.getConcreteField(fieldName) != null || this.schema.getAttribute(fieldName) != null) {
            throw this.newProcessException(this.schema, null, "Incompatible position attribute '" + fieldName + "' already created.");
        }
        boolean isArray = inputField.getDataType() instanceof ArrayDataType;
        SDField field = new SDField(this.repo, fieldName, (DataType)(isArray ? DataType.getArray((DataType)DataType.LONG) : DataType.LONG));
        Attribute attribute = new Attribute(fieldName, Attribute.Type.LONG, isArray ? Attribute.CollectionType.ARRAY : Attribute.CollectionType.SINGLE);
        attribute.setPosition(true);
        attribute.setFastSearch(true);
        field.addAttribute(attribute);
        ScriptExpression script = inputField.getIndexingScript();
        script = (ScriptExpression)new RemoveSummary(inputField.getName()).convert((Expression)script);
        script = (ScriptExpression)new PerformZCurve(field, fieldName).convert((Expression)script);
        field.setIndexingScript(script);
        return field;
    }

    private void ensureCompatibleSummary(SDField field, String sourceName, String summaryName, DataType summaryType, SummaryTransform summaryTransform, Collection<String> summaryTo, boolean validate) {
        SummaryField summary = this.schema.getSummaryField(summaryName);
        if (summary == null) {
            summary = new SummaryField(summaryName, summaryType, summaryTransform);
            summary.addDestination("default");
            summary.addDestinations(summaryTo);
            field.addSummaryField(summary);
        } else if (!summary.getDataType().equals((Object)summaryType)) {
            if (validate) {
                this.fail(this.schema, field, "Incompatible summary field '" + summaryName + "' type " + summary.getDataType() + " already created.");
            }
        } else if (summary.getTransform() == SummaryTransform.NONE) {
            summary.setTransform(summaryTransform);
            summary.addDestination("default");
            summary.addDestinations(summaryTo);
        } else if (summary.getTransform() != summaryTransform) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Summary field " + summaryName + " has wrong transform: " + summary.getTransform());
            return;
        }
        SummaryField.Source source = new SummaryField.Source(sourceName);
        summary.getSources().clear();
        summary.addSource(source);
    }

    private Set<String> removeSummaryTo(SDField field) {
        HashSet<String> summaryTo = new HashSet<String>();
        Collection<SummaryField> summaryFields = field.getSummaryFields().values();
        for (SummaryField summary : summaryFields) {
            summaryTo.addAll(summary.getDestinations());
        }
        field.removeSummaryFields();
        return summaryTo;
    }

    private static boolean isSupportedPositionType(DataType dataType) {
        return GeoPos.isAnyPos(dataType);
    }

    private static class RemoveSummary
    extends ExpressionConverter {
        final String find;

        RemoveSummary(String find) {
            this.find = find;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof SummaryExpression)) {
                return false;
            }
            String fieldName = ((SummaryExpression)exp).getFieldName();
            return fieldName == null || fieldName.equals(this.find);
        }

        protected Expression doConvert(Expression exp) {
            return null;
        }
    }

    private static class PerformZCurve
    extends ExpressionConverter {
        final String find;
        final String replace;
        final boolean isArray;

        PerformZCurve(SDField find, String replace) {
            this.find = find.getName();
            this.replace = replace;
            this.isArray = find.getDataType() instanceof ArrayDataType;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof AttributeExpression)) {
                return false;
            }
            String fieldName = ((AttributeExpression)exp).getFieldName();
            return fieldName == null || fieldName.equals(this.find);
        }

        protected Expression doConvert(Expression exp) {
            return new StatementExpression(new Expression[]{this.isArray ? new ForEachExpression((Expression)new ZCurveExpression()) : new ZCurveExpression(), new AttributeExpression(this.replace)});
        }
    }
}

