/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedStruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ParsedAnnotation
extends ParsedBlock {
    private ParsedStruct wrappedStruct = null;
    private final List<String> inherited = new ArrayList<String>();
    private final List<ParsedAnnotation> resolvedInherits = new ArrayList<ParsedAnnotation>();
    private ParsedDocument ownedBy = null;

    ParsedAnnotation(String name) {
        super(name, "annotation");
    }

    public List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    public List<ParsedAnnotation> getResolvedInherits() {
        assert (this.inherited.size() == this.resolvedInherits.size());
        return List.copyOf(this.resolvedInherits);
    }

    public Optional<ParsedStruct> getStruct() {
        return Optional.ofNullable(this.wrappedStruct);
    }

    public ParsedDocument getOwnerDoc() {
        return this.ownedBy;
    }

    public String getOwnerName() {
        return this.ownedBy.name();
    }

    public ParsedStruct ensureStruct() {
        if (this.wrappedStruct == null) {
            this.wrappedStruct = new ParsedStruct("annotation." + this.name());
            this.wrappedStruct.tagOwner(this.ownedBy);
        }
        return this.wrappedStruct;
    }

    void setStruct(ParsedStruct struct) {
        this.wrappedStruct = struct;
    }

    void inherit(String other) {
        this.inherited.add(other);
    }

    void tagOwner(ParsedDocument owner) {
        this.verifyThat(this.ownedBy == null, "already owned by", this.ownedBy);
        this.ownedBy = owner;
        this.getStruct().ifPresent(s -> s.tagOwner(owner));
    }

    void resolveInherit(String name, ParsedAnnotation parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.resolvedInherits.add(parsed);
    }
}

