/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.SummaryClassField;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class SummaryClass
extends Derived {
    public static final String DOCUMENT_ID_FIELD = "documentid";
    private final int id;
    private boolean accessingDiskSummary = false;
    private final boolean rawAsBase64;
    private final boolean omitSummaryFeatures;
    private final Map<String, SummaryClassField> fields;
    private final DeployLogger deployLogger;

    public SummaryClass(Schema schema, DocumentSummary summary, DeployLogger deployLogger) {
        super(summary.getName());
        this.deployLogger = deployLogger;
        this.rawAsBase64 = schema.isRawAsBase64();
        this.omitSummaryFeatures = summary.omitSummaryFeatures();
        LinkedHashMap<String, SummaryClassField> fields = new LinkedHashMap<String, SummaryClassField>();
        this.deriveFields(schema, summary, fields);
        this.deriveImplicitFields(summary, fields);
        this.fields = Collections.unmodifiableMap(fields);
        this.id = SummaryClass.deriveId(summary.getName(), fields);
    }

    public int id() {
        return this.id;
    }

    private void deriveImplicitFields(DocumentSummary summary, Map<String, SummaryClassField> fields) {
        if (summary.getName().equals("default")) {
            this.addField(DOCUMENT_ID_FIELD, (DataType)DataType.STRING, fields);
        }
    }

    private void deriveFields(Schema schema, DocumentSummary summary, Map<String, SummaryClassField> fields) {
        for (SummaryField summaryField : summary.getSummaryFields().values()) {
            if (!this.accessingDiskSummary && schema.isAccessingDiskSummary(summaryField)) {
                this.accessingDiskSummary = true;
            }
            this.addField(summaryField.getName(), summaryField.getDataType(), summaryField.getTransform(), fields);
        }
    }

    private void addField(String name, DataType type, Map<String, SummaryClassField> fields) {
        this.addField(name, type, null, fields);
    }

    private void addField(String name, DataType type, SummaryTransform transform, Map<String, SummaryClassField> fields) {
        if (fields.containsKey(name)) {
            SummaryClassField sf = fields.get(name);
            if (SummaryClassField.convertDataType(type, transform, this.rawAsBase64) != sf.getType()) {
                this.deployLogger.logApplicationPackage(Level.WARNING, "Conflicting definition of field " + name + ". Declared as type " + sf.getType() + " and " + type);
            }
        } else {
            fields.put(name, new SummaryClassField(name, type, transform, this.rawAsBase64));
        }
    }

    public Map<String, SummaryClassField> fields() {
        return this.fields;
    }

    private static int deriveId(String name, Map<String, SummaryClassField> fields) {
        int hash = name.hashCode();
        int number = 1;
        for (SummaryClassField field : fields.values()) {
            hash += number++ * (field.getName().hashCode() + 17 * field.getType().getName().hashCode());
        }
        if ((hash = Math.abs(hash)) == 0x55555555) {
            ++hash;
        }
        return hash;
    }

    public SummaryConfig.Classes.Builder getSummaryClassConfig() {
        SummaryConfig.Classes.Builder classBuilder = new SummaryConfig.Classes.Builder();
        classBuilder.id(this.id).name(this.getName()).omitsummaryfeatures(this.omitSummaryFeatures);
        for (SummaryClassField field : this.fields.values()) {
            classBuilder.fields(new SummaryConfig.Classes.Fields.Builder().name(field.getName()).type(field.getType().getName()));
        }
        return classBuilder;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    protected String getDerivedName() {
        return "summary";
    }

    public String toString() {
        return "summary class '" + this.getName() + "'";
    }
}

