/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.LargeRankExpressions;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.FileDistributedConstants;
import com.yahoo.searchdefinition.derived.FileDistributedOnnxModels;
import com.yahoo.searchdefinition.derived.RawRankProfile;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class RankProfileList
extends Derived
implements RankProfilesConfig.Producer {
    private final Map<String, RawRankProfile> rankProfiles;
    private final FileDistributedConstants constants;
    private final LargeRankExpressions largeRankExpressions;
    private final FileDistributedOnnxModels onnxModels;
    public static final RankProfileList empty = new RankProfileList();

    private RankProfileList() {
        this.constants = new FileDistributedConstants(null, List.of());
        this.largeRankExpressions = new LargeRankExpressions(null);
        this.onnxModels = new FileDistributedOnnxModels(null, List.of());
        this.rankProfiles = Map.of();
    }

    public RankProfileList(Schema schema, LargeRankExpressions largeRankExpressions, AttributeFields attributeFields, DeployState deployState) {
        this.setName(schema == null ? "default" : schema.getName());
        this.largeRankExpressions = largeRankExpressions;
        this.rankProfiles = this.deriveRankProfiles(schema, attributeFields, deployState);
        this.constants = RankProfileList.deriveFileDistributedConstants(schema, this.rankProfiles.values(), deployState);
        this.onnxModels = RankProfileList.deriveFileDistributedOnnxModels(schema, this.rankProfiles.values(), deployState);
    }

    private boolean areDependenciesReady(RankProfile rank, RankProfileRegistry registry, Set<String> processedProfiles) {
        return rank.inheritedNames().isEmpty() || processedProfiles.containsAll(rank.inheritedNames()) || rank.schema() != null && rank.inheritedNames().stream().allMatch(name -> registry.resolve(rank.schema().getDocument(), (String)name) != null);
    }

    private Map<String, RawRankProfile> deriveRankProfiles(Schema schema, AttributeFields attributeFields, DeployState deployState) {
        LinkedHashMap<String, RawRankProfile> rawRankProfiles = new LinkedHashMap<String, RawRankProfile>();
        if (schema != null) {
            RawRankProfile rawRank = new RawRankProfile(deployState.rankProfileRegistry().get(schema, "default"), this.largeRankExpressions, deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels(), attributeFields, deployState.getProperties());
            rawRankProfiles.put(rawRank.getName(), rawRank);
        }
        LinkedHashMap<String, RankProfile> remaining = new LinkedHashMap<String, RankProfile>();
        deployState.rankProfileRegistry().rankProfilesOf(schema).forEach(rank -> remaining.put(rank.name(), (RankProfile)rank));
        remaining.remove("default");
        while (!remaining.isEmpty()) {
            ArrayList<RankProfile> ready = new ArrayList<RankProfile>();
            remaining.forEach((name, profile) -> {
                if (this.areDependenciesReady((RankProfile)profile, deployState.rankProfileRegistry(), rawRankProfiles.keySet())) {
                    ready.add((RankProfile)profile);
                }
            });
            rawRankProfiles.putAll(this.processRankProfiles(ready, deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels(), attributeFields, deployState.getProperties(), deployState.getExecutor()));
            ready.forEach(rank -> remaining.remove(rank.name()));
        }
        return rawRankProfiles;
    }

    private Map<String, RawRankProfile> processRankProfiles(List<RankProfile> profiles, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, AttributeFields attributeFields, ModelContext.Properties deployProperties, ExecutorService executor) {
        LinkedHashMap<String, Future<RawRankProfile>> futureRawRankProfiles = new LinkedHashMap<String, Future<RawRankProfile>>();
        for (RankProfile profile : profiles) {
            futureRawRankProfiles.put(profile.name(), executor.submit(() -> new RawRankProfile(profile, this.largeRankExpressions, queryProfiles, importedModels, attributeFields, deployProperties)));
        }
        try {
            LinkedHashMap<String, RawRankProfile> rawRankProfiles = new LinkedHashMap<String, RawRankProfile>();
            for (Future rawFuture : futureRawRankProfiles.values()) {
                RawRankProfile rawRank = (RawRankProfile)rawFuture.get();
                rawRankProfiles.put(rawRank.getName(), rawRank);
            }
            return rawRankProfiles;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static FileDistributedConstants deriveFileDistributedConstants(Schema schema, Collection<RawRankProfile> rankProfiles, DeployState deployState) {
        HashMap<Reference, RankProfile.Constant> allFileConstants = new HashMap<Reference, RankProfile.Constant>();
        RankProfileList.addFileConstants(schema != null ? schema.constants().values() : List.of(), allFileConstants, schema != null ? schema.toString() : "[global]");
        for (RawRankProfile profile : rankProfiles) {
            RankProfileList.addFileConstants(profile.compiled().constants().values(), allFileConstants, profile.toString());
        }
        return new FileDistributedConstants(deployState.getFileRegistry(), allFileConstants.values());
    }

    private static void addFileConstants(Collection<RankProfile.Constant> source, Map<Reference, RankProfile.Constant> destination, String sourceName) {
        for (RankProfile.Constant constant : source) {
            if (constant.valuePath().isEmpty()) continue;
            RankProfile.Constant existing = destination.get(constant.name());
            if (existing != null && !constant.equals(existing)) {
                throw new IllegalArgumentException("Duplicate constants: " + sourceName + " have " + constant + ", but we already have " + existing + ": Value reference constants must be unique across all rank profiles/models");
            }
            destination.put(constant.name(), constant);
        }
    }

    private static FileDistributedOnnxModels deriveFileDistributedOnnxModels(Schema schema, Collection<RawRankProfile> rankProfiles, DeployState deployState) {
        LinkedHashMap<String, OnnxModel> allModels = new LinkedHashMap<String, OnnxModel>();
        RankProfileList.addOnnxModels(schema != null ? schema.onnxModels().values() : List.of(), allModels, schema != null ? schema.toString() : "[global]");
        for (RawRankProfile profile : rankProfiles) {
            RankProfileList.addOnnxModels(profile.compiled().onnxModels().values(), allModels, profile.toString());
        }
        return new FileDistributedOnnxModels(deployState.getFileRegistry(), allModels.values());
    }

    private static void addOnnxModels(Collection<OnnxModel> source, Map<String, OnnxModel> destination, String sourceName) {
        for (OnnxModel model : source) {
            OnnxModel existing = destination.get(model.getName());
            if (existing != null && !model.equals(existing)) {
                throw new IllegalArgumentException("Duplicate onnx model: " + sourceName + " have " + model + ", but we already have " + existing + ": Onnx models must be unique across all rank profiles/models");
            }
            destination.put(model.getName(), model);
        }
    }

    public Map<String, RawRankProfile> getRankProfiles() {
        return this.rankProfiles;
    }

    public FileDistributedConstants constants() {
        return this.constants;
    }

    public FileDistributedOnnxModels getOnnxModels() {
        return this.onnxModels;
    }

    @Override
    public String getDerivedName() {
        return "rank-profiles";
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        for (RawRankProfile rank : this.rankProfiles.values()) {
            rank.getConfig(builder);
        }
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        this.largeRankExpressions.expressions().forEach(expr -> builder.expression.add(new RankingExpressionsConfig.Expression.Builder().name(expr.getName()).fileref(expr.getFileReference())));
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        this.constants.getConfig(builder);
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        this.onnxModels.getConfig(builder);
    }
}

