/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.path.Path;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DistributableResource
implements Comparable<DistributableResource> {
    private final String name;
    private PathType pathType;
    private String path;
    private FileReference fileReference = new FileReference("");

    public PathType getPathType() {
        return this.pathType;
    }

    public DistributableResource(String name) {
        this(name, null, PathType.FILE);
    }

    public DistributableResource(String name, String path) {
        this(name, path, PathType.FILE);
    }

    public DistributableResource(String name, String path, PathType type) {
        this.name = name;
        this.path = path;
        this.pathType = type;
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri, "uri cannot be null");
        this.path = uri;
        this.pathType = PathType.URI;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.path;
    }

    public Path getFilePath() {
        return Path.fromString((String)this.path);
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference.value();
    }

    public void validate() {
        switch (this.pathType) {
            case FILE: 
            case URI: {
                if (this.path != null && !this.path.isEmpty()) break;
                throw new IllegalArgumentException("Distributable URI/FILE resource must have a file or uri.");
            }
        }
    }

    public void register(FileRegistry fileRegistry) {
        switch (this.pathType) {
            case FILE: {
                this.fileReference = fileRegistry.addFile(this.path);
                break;
            }
            case URI: {
                this.fileReference = fileRegistry.addUri(this.path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown path type " + this.pathType);
            }
        }
    }

    protected void register(FileRegistry fileRegistry, ByteBuffer blob) {
        this.fileReference = fileRegistry.addBlob(this.path, blob);
    }

    public String toString() {
        return "resource '" + this.name + " of type '" + this.pathType + "' with ref '" + this.fileReference + "'";
    }

    @Override
    public int compareTo(DistributableResource o) {
        return this.name.compareTo(o.getName());
    }

    public static enum PathType {
        FILE,
        URI,
        BLOB;

    }
}

