/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ComponentAdaptor;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import com.yahoo.vespa.model.container.search.searchchain.Source;
import com.yahoo.vespa.model.container.search.searchchain.SourceGroup;
import java.util.ArrayList;
import java.util.Collection;

class SourceGroupRegistry {
    private final ComponentRegistry<ComponentAdaptor<SourceGroup>> sourceGroups = new ComponentRegistry();

    SourceGroupRegistry() {
    }

    private void add(Source source) {
        this.getGroup(source.getComponentId()).add(source);
    }

    private SourceGroup getGroup(ComponentId sourceId) {
        ComponentAdaptor group = (ComponentAdaptor)this.sourceGroups.getComponent(sourceId);
        if (group == null) {
            group = new ComponentAdaptor(sourceId, (Object)new SourceGroup(sourceId));
            this.sourceGroups.register(group.getId(), (Object)group);
        }
        return (SourceGroup)group.model;
    }

    void addSources(Provider provider) {
        for (Source source : provider.getSources()) {
            this.add(source);
        }
    }

    public Collection<SourceGroup> groups() {
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (ComponentAdaptor group : this.sourceGroups.allComponents()) {
            result.add((SourceGroup)group.model);
        }
        return result;
    }

    public SourceGroup getComponent(ComponentSpecification spec) {
        ComponentAdaptor result = (ComponentAdaptor)this.sourceGroups.getComponent(spec);
        return result != null ? (SourceGroup)result.model : null;
    }
}

