/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing.multifieldresolver;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.TensorFieldType;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Map;
import java.util.Optional;

public class RankProfileTypeSettingsProcessor
extends Processor {
    public RankProfileTypeSettingsProcessor(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        this.processAttributeFields();
        this.processImportedFields();
        this.processQueryProfileTypes();
    }

    private void processAttributeFields() {
        if (this.schema == null) {
            return;
        }
        for (ImmutableSDField immutableSDField : this.schema.allConcreteFields()) {
            Attribute attribute = immutableSDField.getAttributes().get(immutableSDField.getName());
            if (attribute == null || !attribute.tensorType().isPresent()) continue;
            this.addAttributeTypeToRankProfiles(attribute.getName(), attribute.tensorType().get().toString());
        }
    }

    private void processImportedFields() {
        if (this.schema == null) {
            return;
        }
        Optional<ImportedFields> importedFields = this.schema.importedFields();
        if (importedFields.isPresent()) {
            importedFields.get().fields().forEach((fieldName, field) -> this.processImportedField((ImportedField)field));
        }
    }

    private void processImportedField(ImportedField field) {
        ImmutableSDField targetField = field.targetField();
        Attribute attribute = targetField.getAttributes().get(targetField.getName());
        if (attribute != null && attribute.tensorType().isPresent()) {
            this.addAttributeTypeToRankProfiles(field.fieldName(), attribute.tensorType().get().toString());
        }
    }

    private void addAttributeTypeToRankProfiles(String attributeName, String attributeType) {
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            profile.addAttributeType(attributeName, attributeType);
        }
    }

    private void processQueryProfileTypes() {
        for (QueryProfileType queryProfileType : this.queryProfiles.getRegistry().getTypeRegistry().allComponents()) {
            for (Map.Entry fieldDescEntry : queryProfileType.fields().entrySet()) {
                this.processFieldDescription((FieldDescription)fieldDescEntry.getValue());
            }
        }
    }

    private void processFieldDescription(FieldDescription fieldDescription) {
        FieldType fieldType = fieldDescription.getType();
        if (fieldType instanceof TensorFieldType) {
            TensorFieldType tensorFieldType = (TensorFieldType)fieldType;
            Optional reference = Reference.simple((String)fieldDescription.getName());
            if (reference.isPresent() && FeatureNames.isQueryFeature((Reference)reference.get())) {
                this.addQueryFeatureTypeToRankProfiles((Reference)reference.get(), tensorFieldType.asTensorType());
            }
        }
    }

    private void addQueryFeatureTypeToRankProfiles(Reference queryFeature, TensorType queryFeatureType) {
        for (RankProfile profile : this.rankProfileRegistry.all()) {
            if (profile.inputs().containsKey(queryFeature)) continue;
            profile.addInput(queryFeature, queryFeatureType);
        }
    }
}

