/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.MatchType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.IndexingOutputs;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.TypedTransformProvider;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TokenizeExpression;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Set;
import java.util.TreeSet;

public class TextMatch
extends Processor {
    public TextMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script;
            if (field.getMatching().getType() != MatchType.TEXT || (script = field.getIndexingScript()) == null) continue;
            DataType fieldType = field.getDataType();
            if (fieldType instanceof CollectionDataType) {
                fieldType = ((CollectionDataType)fieldType).getNestedType();
            }
            if (fieldType != DataType.STRING) continue;
            TreeSet<String> dynamicSummary = new TreeSet<String>();
            TreeSet<String> staticSummary = new TreeSet<String>();
            new IndexingOutputs(this.schema, this.deployLogger, this.rankProfileRegistry, this.queryProfiles).findSummaryTo(this.schema, field, dynamicSummary, staticSummary);
            MyVisitor visitor = new MyVisitor(dynamicSummary);
            visitor.visit((Expression)script);
            if (!visitor.requiresTokenize) continue;
            MyStringTokenizer converter = new MyStringTokenizer(this.schema, this.findAnnotatorConfig(this.schema, field));
            field.setIndexingScript((ScriptExpression)converter.convert((Expression)script));
        }
    }

    private AnnotatorConfig findAnnotatorConfig(Schema schema, SDField field) {
        AnnotatorConfig ret = new AnnotatorConfig();
        Stemming activeStemming = field.getStemming();
        if (activeStemming == null) {
            activeStemming = schema.getStemming();
        }
        ret.setStemMode(activeStemming.toStemMode());
        ret.setRemoveAccents(field.getNormalizing().doRemoveAccents());
        if (field.getMatching() != null && field.getMatching().maxLength() != null) {
            ret.setMaxTokenLength(field.getMatching().maxLength().intValue());
        }
        return ret;
    }

    private static class MyVisitor
    extends ExpressionVisitor {
        final Set<String> dynamicSummaryFields;
        boolean requiresTokenize = false;

        MyVisitor(Set<String> dynamicSummaryFields) {
            this.dynamicSummaryFields = dynamicSummaryFields;
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof IndexExpression) {
                this.requiresTokenize = true;
            }
            if (exp instanceof SummaryExpression && this.dynamicSummaryFields.contains(((SummaryExpression)exp).getFieldName())) {
                this.requiresTokenize = true;
            }
        }
    }

    private static class MyStringTokenizer
    extends TypedTransformProvider {
        final AnnotatorConfig annotatorCfg;

        MyStringTokenizer(Schema schema, AnnotatorConfig annotatorCfg) {
            super(TokenizeExpression.class, schema);
            this.annotatorCfg = annotatorCfg;
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            TokenizeExpression exp = new TokenizeExpression(null, this.annotatorCfg);
            if (fieldType instanceof CollectionDataType) {
                exp = new ForEachExpression((Expression)exp);
            }
            return exp;
        }
    }
}

