/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.MatchType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.TypedTransformProvider;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.NGramExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class NGramMatch
extends Processor {
    public static final int DEFAULT_GRAM_SIZE = 2;

    public NGramMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            if (field.getMatching().getType().equals((Object)MatchType.GRAM)) {
                this.implementGramMatch(this.schema, field, validate);
                continue;
            }
            if (!validate || field.getMatching().getGramSize() < 0) continue;
            throw new IllegalArgumentException("gram-size can only be set when the matching mode is 'gram'");
        }
    }

    private void implementGramMatch(Schema schema, SDField field, boolean validate) {
        if (validate && field.doesAttributing() && !field.doesIndexing()) {
            throw new IllegalArgumentException("gram matching is not supported with attributes, use 'index' in indexing");
        }
        int n = field.getMatching().getGramSize();
        if (n < 0) {
            n = 2;
        }
        if (validate && n == 0) {
            throw new IllegalArgumentException("Illegal gram size in " + field + ": Must be at least 1");
        }
        field.getNormalizing().inferCodepoint();
        field.setStemming(Stemming.NONE);
        field.addQueryCommand("ngram " + n);
        field.setIndexingScript((ScriptExpression)new MyProvider(schema, n).convert((Expression)field.getIndexingScript()));
    }

    private static class MyProvider
    extends TypedTransformProvider {
        final int ngram;

        MyProvider(Schema schema, int ngram) {
            super(NGramExpression.class, schema);
            this.ngram = ngram;
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            NGramExpression exp = new NGramExpression(null, this.ngram);
            if (fieldType instanceof CollectionDataType) {
                exp = new ForEachExpression((Expression)exp);
            }
            return exp;
        }
    }
}

