/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.derived.SummaryMap;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SearchCluster
extends AbstractConfigProducer<SearchCluster>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer {
    private final String clusterName;
    private int index;
    private Double queryTimeout;
    private Double visibilityDelay = 0.0;
    private final Map<String, SchemaInfo> schemas = new LinkedHashMap<String, SchemaInfo>();

    public SearchCluster(AbstractConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public void add(SchemaInfo schema) {
        this.schemas.put(schema.name(), schema);
    }

    public Map<String, SchemaInfo> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public abstract void deriveFromSchemas(DeployState var1);

    protected void convertSummaryConfig(SummaryConfig.Producer summaryConfigProducer, SummarymapConfig.Producer summarymapConfigProducer, DocumentdbInfoConfig.Documentdb.Builder docDb) {
        SummaryConfig.Builder summaryConfigBuilder = new SummaryConfig.Builder();
        summaryConfigProducer.getConfig(summaryConfigBuilder);
        SummaryConfig summaryConfig = summaryConfigBuilder.build();
        SummarymapConfig summarymapConfig = null;
        if (summarymapConfigProducer != null) {
            SummarymapConfig.Builder summarymapConfigBuilder = new SummarymapConfig.Builder();
            summarymapConfigProducer.getConfig(summarymapConfigBuilder);
            summarymapConfig = summarymapConfigBuilder.build();
        }
        for (SummaryConfig.Classes sclass : summaryConfig.classes()) {
            DocumentdbInfoConfig.Documentdb.Summaryclass.Builder sumClassBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Builder();
            sumClassBuilder.id(sclass.id()).name(sclass.name());
            for (SummaryConfig.Classes.Fields field : sclass.fields()) {
                DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder fieldsBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder();
                fieldsBuilder.name(field.name()).type(field.type()).dynamic(this.isDynamic(field.name(), summarymapConfig));
                sumClassBuilder.fields(fieldsBuilder);
            }
            docDb.summaryclass(sumClassBuilder);
        }
    }

    private boolean isDynamic(String fieldName, SummarymapConfig summarymapConfig) {
        if (summarymapConfig == null) {
            return false;
        }
        for (SummarymapConfig.Override override : summarymapConfig.override()) {
            if (!fieldName.equals(override.field()) || !SummaryMap.isDynamicCommand(override.command())) continue;
            return true;
        }
        return false;
    }

    protected void addRankProfilesConfig(String schemaName, DocumentdbInfoConfig.Documentdb.Builder docDbBuilder) {
        for (RankProfileInfo rankProfile : this.schemas().get(schemaName).rankProfiles().values()) {
            DocumentdbInfoConfig.Documentdb.Rankprofile.Builder rankProfileConfig = new DocumentdbInfoConfig.Documentdb.Rankprofile.Builder();
            rankProfileConfig.name(rankProfile.name());
            rankProfileConfig.hasSummaryFeatures(rankProfile.hasSummaryFeatures());
            rankProfileConfig.hasRankFeatures(rankProfile.hasRankFeatures());
            for (Map.Entry<Reference, TensorType> input : rankProfile.inputs().entrySet()) {
                DocumentdbInfoConfig.Documentdb.Rankprofile.Input.Builder inputConfig = new DocumentdbInfoConfig.Documentdb.Rankprofile.Input.Builder();
                inputConfig.name(input.getKey().toString());
                inputConfig.type(input.getValue().toString());
                rankProfileConfig.input(inputConfig);
            }
            docDbBuilder.rankprofile(rankProfileConfig);
        }
    }

    public List<String> getDocumentNames() {
        return this.schemas.values().stream().map(schema -> schema.fullSchema().getDocument().getDocumentName().getName()).collect(Collectors.toList());
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final String getIndexingModeName() {
        return this.getIndexingMode().getName();
    }

    public final boolean isStreaming() {
        return this.getIndexingMode() == IndexingMode.STREAMING;
    }

    public final void setQueryTimeout(Double to) {
        this.queryTimeout = to;
    }

    public final void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
    }

    protected abstract IndexingMode getIndexingMode();

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public abstract int getRowBits();

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public abstract void defaultDocumentsConfig();

    public abstract DerivedConfiguration getSchemaConfig();

    public void getConfig(IndexInfoConfig.Builder builder) {
        if (this.getSchemaConfig() != null) {
            this.getSchemaConfig().getIndexInfo().getConfig(builder);
        }
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        if (this.getSchemaConfig() != null) {
            this.getSchemaConfig().getIndexingScript().getConfig(builder);
        }
    }

    public void getConfig(AttributesConfig.Builder builder) {
        if (this.getSchemaConfig() != null) {
            this.getSchemaConfig().getConfig(builder);
        }
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.getSchemaConfig() != null) {
            this.getSchemaConfig().getRankProfileList().getConfig(builder);
        }
    }

    public abstract void getConfig(DocumentdbInfoConfig.Builder var1);

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    public static final class SchemaInfo {
        private final Schema schema;
        private final UserConfigRepo userConfigRepo;
        private final Map<String, RankProfileInfo> rankProfiles;

        public SchemaInfo(Schema schema, UserConfigRepo userConfigRepo, RankProfileRegistry rankProfileRegistry) {
            this.schema = schema;
            this.userConfigRepo = userConfigRepo;
            this.rankProfiles = Collections.unmodifiableMap(this.toRankProfiles(rankProfileRegistry.rankProfilesOf(schema)));
        }

        public String name() {
            return this.schema.getName();
        }

        public Schema fullSchema() {
            return this.schema;
        }

        public UserConfigRepo userConfigs() {
            return this.userConfigRepo;
        }

        public Map<String, RankProfileInfo> rankProfiles() {
            return this.rankProfiles;
        }

        private Map<String, RankProfileInfo> toRankProfiles(Collection<RankProfile> rankProfiles) {
            LinkedHashMap<String, RankProfileInfo> rankProfileInfos = new LinkedHashMap<String, RankProfileInfo>();
            rankProfiles.forEach(profile -> rankProfileInfos.put(profile.name(), new RankProfileInfo((RankProfile)profile)));
            return rankProfileInfos;
        }
    }

    public static final class RankProfileInfo {
        private final String name;
        private final boolean hasSummaryFeatures;
        private final boolean hasRankFeatures;
        private final Map<Reference, TensorType> inputs;

        public RankProfileInfo(RankProfile profile) {
            this.name = profile.name();
            this.hasSummaryFeatures = !profile.getSummaryFeatures().isEmpty();
            this.hasRankFeatures = !profile.getRankFeatures().isEmpty();
            this.inputs = profile.inputs();
        }

        public String name() {
            return this.name;
        }

        public boolean hasSummaryFeatures() {
            return this.hasSummaryFeatures;
        }

        public boolean hasRankFeatures() {
            return this.hasRankFeatures;
        }

        public Map<Reference, TensorType> inputs() {
            return this.inputs;
        }
    }

    public static final class IndexingMode {
        public static final IndexingMode REALTIME = new IndexingMode("REALTIME");
        public static final IndexingMode STREAMING = new IndexingMode("STREAMING");
        private final String name;

        private IndexingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "indexingmode: " + this.name;
        }
    }
}

