/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.tensor.TensorType;

class ParsedType {
    private final String name;
    private final ParsedType keyType;
    private final ParsedType valType;
    private final TensorType tensorType;
    private Variant variant;
    private boolean createIfNonExistent = false;
    private boolean removeIfZero = false;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[type ").append((Object)this.variant).append("] {");
        switch (this.variant) {
            case NONE: {
                break;
            }
            case BUILTIN: {
                buf.append(this.name);
                break;
            }
            case POSITION: {
                buf.append(this.name);
                break;
            }
            case TENSOR: {
                buf.append(this.tensorType.toString());
                break;
            }
            case ARRAY: {
                buf.append(" array<").append(this.valType.toString()).append("> ");
                break;
            }
            case WSET: {
                buf.append(" weightedset<").append(this.valType.toString()).append(">");
                if (this.createIfNonExistent) {
                    buf.append(",createIfNonExistent");
                }
                if (this.removeIfZero) {
                    buf.append(",removeIfZero");
                }
                buf.append(" ");
                break;
            }
            case MAP: {
                buf.append(" map<").append(this.keyType.toString()).append(",").append(this.valType.toString()).append("> ");
                break;
            }
            case DOC_REFERENCE: {
                buf.append(" reference<").append(this.valType.toString()).append("> ");
                break;
            }
            case ANN_REFERENCE: {
                buf.append(" ").append(this.toString()).append(" ");
                break;
            }
            case STRUCT: 
            case DOCUMENT: 
            case UNKNOWN: {
                buf.append(" ").append(this.name).append(" ");
            }
        }
        buf.append("}");
        return buf.toString();
    }

    private static Variant guessVariant(String name) {
        switch (name) {
            case "bool": {
                return Variant.BUILTIN;
            }
            case "byte": {
                return Variant.BUILTIN;
            }
            case "int": {
                return Variant.BUILTIN;
            }
            case "long": {
                return Variant.BUILTIN;
            }
            case "string": {
                return Variant.BUILTIN;
            }
            case "float": {
                return Variant.BUILTIN;
            }
            case "double": {
                return Variant.BUILTIN;
            }
            case "uri": {
                return Variant.BUILTIN;
            }
            case "predicate": {
                return Variant.BUILTIN;
            }
            case "raw": {
                return Variant.BUILTIN;
            }
            case "tag": {
                return Variant.BUILTIN;
            }
            case "position": {
                return Variant.POSITION;
            }
            case "float16": {
                return Variant.BUILTIN;
            }
        }
        return Variant.UNKNOWN;
    }

    public String name() {
        return this.name;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public ParsedType mapKeyType() {
        assert (this.variant == Variant.MAP);
        return this.keyType;
    }

    public ParsedType mapValueType() {
        assert (this.variant == Variant.MAP);
        return this.valType;
    }

    public ParsedType nestedType() {
        assert (this.variant == Variant.ARRAY || this.variant == Variant.WSET);
        assert (this.valType != null);
        return this.valType;
    }

    public boolean getCreateIfNonExistent() {
        assert (this.variant == Variant.WSET);
        return this.createIfNonExistent;
    }

    public boolean getRemoveIfZero() {
        assert (this.variant == Variant.WSET);
        return this.removeIfZero;
    }

    public ParsedType getReferencedDocumentType() {
        assert (this.variant == Variant.DOC_REFERENCE);
        return this.valType;
    }

    public TensorType getTensorType() {
        assert (this.variant == Variant.TENSOR);
        return this.tensorType;
    }

    public String getNameOfReferencedAnnotation() {
        assert (this.variant == Variant.ANN_REFERENCE);
        String prefix = "annotationreference<";
        int fromPos = prefix.length();
        int toPos = this.name.length() - 1;
        return this.name.substring(fromPos, toPos);
    }

    private ParsedType(String name, Variant variant) {
        this(name, variant, null, null, null);
    }

    private ParsedType(String name, Variant variant, ParsedType vt) {
        this(name, variant, null, vt, null);
    }

    private ParsedType(String name, Variant variant, ParsedType kt, ParsedType vt) {
        this(name, variant, kt, vt, null);
    }

    private ParsedType(String name, Variant variant, ParsedType kt, ParsedType vt, TensorType tType) {
        this.name = name;
        this.variant = variant;
        this.keyType = kt;
        this.valType = vt;
        this.tensorType = tType;
    }

    static ParsedType mapType(ParsedType kt, ParsedType vt) {
        assert (kt != null);
        assert (vt != null);
        String name = "map<" + kt.name() + "," + vt.name() + ">";
        return new ParsedType(name, Variant.MAP, kt, vt);
    }

    static ParsedType arrayOf(ParsedType vt) {
        assert (vt != null);
        return new ParsedType("array<" + vt.name() + ">", Variant.ARRAY, vt);
    }

    static ParsedType wsetOf(ParsedType vt) {
        assert (vt != null);
        return new ParsedType("weightedset<" + vt.name() + ">", Variant.WSET, vt);
    }

    static ParsedType documentRef(ParsedType docType) {
        assert (docType != null);
        return new ParsedType("reference<" + docType.name + ">", Variant.DOC_REFERENCE, docType);
    }

    static ParsedType annotationRef(String name) {
        return new ParsedType("annotationreference<" + name + ">", Variant.ANN_REFERENCE);
    }

    static ParsedType tensorType(TensorType tType) {
        assert (tType != null);
        return new ParsedType(tType.toString(), Variant.TENSOR, null, null, tType);
    }

    static ParsedType fromName(String name) {
        return new ParsedType(name, ParsedType.guessVariant(name));
    }

    static ParsedType documentType(String name) {
        return new ParsedType(name, Variant.DOCUMENT);
    }

    void setCreateIfNonExistent(boolean value) {
        if (this.variant != Variant.WSET) {
            throw new IllegalArgumentException("CreateIfNonExistent only valid for weightedset, not " + this.variant);
        }
        this.createIfNonExistent = value;
    }

    void setRemoveIfZero(boolean value) {
        if (this.variant != Variant.WSET) {
            throw new IllegalArgumentException("RemoveIfZero only valid for weightedset, not " + this.variant);
        }
        this.removeIfZero = value;
    }

    void setVariant(Variant value) {
        if (this.variant == value) {
            return;
        }
        if (this.variant != Variant.UNKNOWN) {
            throw new IllegalArgumentException("setVariant(" + value + ") only valid for UNKNOWN, not: " + this.variant);
        }
        this.variant = value;
    }

    public static enum Variant {
        NONE,
        BUILTIN,
        POSITION,
        TENSOR,
        ARRAY,
        WSET,
        MAP,
        DOC_REFERENCE,
        ANN_REFERENCE,
        STRUCT,
        DOCUMENT,
        UNKNOWN;

    }
}

