/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.searchdefinition.parser.InheritanceResolver;
import com.yahoo.searchdefinition.parser.IntermediateParser;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.ParsedSchema;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.TokenMgrException;
import com.yahoo.yolean.Exceptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class IntermediateCollection {
    private final DeployLogger deployLogger;
    private final ModelContext.Properties modelProperties;
    private Map<String, ParsedSchema> parsedSchemas = new LinkedHashMap<String, ParsedSchema>();

    IntermediateCollection() {
        this.deployLogger = new BaseDeployLogger();
        this.modelProperties = new TestProperties();
    }

    public IntermediateCollection(DeployLogger logger, ModelContext.Properties properties) {
        this.deployLogger = logger;
        this.modelProperties = properties;
    }

    public Map<String, ParsedSchema> getParsedSchemas() {
        return Collections.unmodifiableMap(this.parsedSchemas);
    }

    public ParsedSchema getParsedSchema(String name) {
        return this.parsedSchemas.get(name);
    }

    public ParsedSchema addSchemaFromString(String input) throws ParseException {
        SimpleCharStream stream = new SimpleCharStream(input);
        IntermediateParser parser = new IntermediateParser(stream, this.deployLogger, this.modelProperties);
        try {
            ParsedSchema schema = parser.schema();
            if (this.parsedSchemas.containsKey(schema.name())) {
                throw new IllegalArgumentException("Duplicate schemas named: " + schema.name());
            }
            this.parsedSchemas.put(schema.name(), schema);
            return schema;
        }
        catch (TokenMgrException e) {
            throw new ParseException("Unknown symbol: " + e.getMessage());
        }
        catch (ParseException pe) {
            throw new ParseException(stream.formatException(Exceptions.toMessageString((Throwable)pe)));
        }
    }

    private String addSchemaFromStringWithFileName(String input, String fileName) throws ParseException {
        ParsedSchema parsed = this.addSchemaFromString(input);
        String nameFromFile = this.baseName(fileName);
        if (!parsed.name().equals(nameFromFile)) {
            throw new IllegalArgumentException("The file containing schema '" + parsed.name() + "' must be named '" + parsed.name() + ".sd', was '" + this.stripDirs(fileName) + "'");
        }
        return parsed.name();
    }

    private String baseName(String filename) {
        int pos = filename.lastIndexOf(47);
        if (pos != -1) {
            filename = filename.substring(pos + 1);
        }
        if ((pos = filename.lastIndexOf(46)) != -1) {
            filename = filename.substring(0, pos);
        }
        return filename;
    }

    private String stripDirs(String filename) {
        int pos = filename.lastIndexOf(47);
        if (pos != -1) {
            return filename.substring(pos + 1);
        }
        return filename;
    }

    public String addSchemaFromReader(NamedReader reader) throws ParseException {
        try {
            String nameParsed = this.addSchemaFromStringWithFileName(IOUtils.readAll((Reader)reader.getReader()), reader.getName());
            reader.close();
            return nameParsed;
        }
        catch (ParseException ex) {
            throw new ParseException("Failed parsing schema from " + reader.getName() + ": " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed reading from " + reader.getName() + ": " + ex.getMessage());
        }
    }

    public String addSchemaFromFile(String fileName) throws ParseException {
        try {
            ParsedSchema parsed = this.addSchemaFromString(IOUtils.readFile((File)new File(fileName)));
            return parsed.name();
        }
        catch (ParseException ex) {
            throw new ParseException("Failed parsing schema from " + fileName + ": " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not read file " + fileName + ": " + ex.getMessage());
        }
    }

    public void addRankProfileFile(String schemaName, NamedReader reader) throws ParseException {
        try {
            ParsedSchema schema = this.parsedSchemas.get(schemaName);
            if (schema == null) {
                throw new IllegalArgumentException("No schema named: " + schemaName);
            }
            SimpleCharStream stream = new SimpleCharStream(IOUtils.readAll((Reader)reader.getReader()));
            IntermediateParser parser = new IntermediateParser(stream, this.deployLogger, this.modelProperties);
            try {
                parser.rankProfile(schema);
            }
            catch (ParseException pe) {
                throw new ParseException("Failed parsing rank-profile from " + reader.getName() + ": " + stream.formatException(Exceptions.toMessageString((Throwable)pe)));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed reading from " + reader.getName() + ": " + ex.getMessage());
        }
    }

    void addRankProfileFile(String schemaName, String fileName) throws ParseException {
        try {
            BufferedReader reader = IOUtils.createReader((String)fileName, (String)"UTF-8");
            this.addRankProfileFile(schemaName, new NamedReader(fileName, (Reader)reader));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not read file " + fileName + ": " + ex.getMessage());
        }
    }

    void resolveInternalConnections() {
        InheritanceResolver resolver = new InheritanceResolver(this.parsedSchemas);
        resolver.resolveInheritance();
    }
}

