/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.parser.ParsedRankFunction;
import com.yahoo.searchdefinition.parser.ParsedRankProfile;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.TensorType;
import java.util.List;
import java.util.Map;

public class ConvertParsedRanking {
    private final RankProfileRegistry rankProfileRegistry;

    ConvertParsedRanking() {
        this(new RankProfileRegistry());
    }

    public ConvertParsedRanking(RankProfileRegistry rankProfileRegistry) {
        this.rankProfileRegistry = rankProfileRegistry;
    }

    private RankProfile makeRankProfile(Schema schema, String name) {
        if (name.equals("default")) {
            return this.rankProfileRegistry.get(schema, "default");
        }
        return new RankProfile(name, schema, this.rankProfileRegistry, schema.rankingConstants());
    }

    void convertRankProfile(Schema schema, ParsedRankProfile parsed) {
        String name;
        RankProfile profile = this.makeRankProfile(schema, parsed.name());
        assert (profile != null);
        for (String string : parsed.getInherited()) {
            profile.inherit(string);
        }
        parsed.isStrict().ifPresent(value -> profile.setStrict((Boolean)value));
        for (Map.Entry entry : parsed.getConstants().entrySet()) {
            name = (String)entry.getKey();
            Value value2 = (Value)entry.getValue();
            if (value2 instanceof TensorValue) {
                TensorValue tensor = (TensorValue)value2;
                profile.addConstantTensor(name, tensor);
                continue;
            }
            profile.addConstant(name, value2);
        }
        for (Map.Entry entry : parsed.getInputs().entrySet()) {
            profile.addInput((Reference)entry.getKey(), (TensorType)entry.getValue());
        }
        for (ParsedRankFunction parsedRankFunction : parsed.getFunctions()) {
            name = parsedRankFunction.name();
            List<String> parameters = parsedRankFunction.getParameters();
            String expression = parsedRankFunction.getExpression();
            boolean inline = parsedRankFunction.getInline();
            profile.addFunction(name, parameters, expression, inline);
        }
        parsed.getRankScoreDropLimit().ifPresent(value -> profile.setRankScoreDropLimit((double)value));
        parsed.getTermwiseLimit().ifPresent(value -> profile.setTermwiseLimit((double)value));
        parsed.getKeepRankCount().ifPresent(value -> profile.setKeepRankCount((int)value));
        parsed.getMinHitsPerThread().ifPresent(value -> profile.setMinHitsPerThread((int)value));
        parsed.getNumSearchPartitions().ifPresent(value -> profile.setNumSearchPartitions((int)value));
        parsed.getNumThreadsPerSearch().ifPresent(value -> profile.setNumThreadsPerSearch((int)value));
        parsed.getReRankCount().ifPresent(value -> profile.setRerankCount((int)value));
        parsed.getMatchPhaseSettings().ifPresent(value -> profile.setMatchPhaseSettings((RankProfile.MatchPhaseSettings)value));
        parsed.getFirstPhaseExpression().ifPresent(value -> profile.setFirstPhaseRanking((String)value));
        parsed.getSecondPhaseExpression().ifPresent(value -> profile.setSecondPhaseRanking((String)value));
        for (FeatureList featureList : parsed.getMatchFeatures()) {
            profile.addMatchFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getRankFeatures()) {
            profile.addRankFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getSummaryFeatures()) {
            profile.addSummaryFeatures(featureList);
        }
        parsed.getInheritedMatchFeatures().ifPresent(value -> profile.setInheritedMatchFeatures((String)value));
        parsed.getInheritedSummaryFeatures().ifPresent(value -> profile.setInheritedSummaryFeatures((String)value));
        if (parsed.getIgnoreDefaultRankFeatures()) {
            profile.setIgnoreDefaultRankFeatures(true);
        }
        for (RankProfile.MutateOperation mutateOperation : parsed.getMutateOperations()) {
            profile.addMutateOperation(mutateOperation);
        }
        parsed.getFieldsWithRankFilter().forEach((fieldName, isFilter) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.PREFERBITVECTOR, isFilter));
        parsed.getFieldsWithRankWeight().forEach((fieldName, weight) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.WEIGHT, weight));
        parsed.getFieldsWithRankType().forEach((fieldName, rankType) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(rankType)));
        parsed.getRankProperties().forEach((key, values) -> {
            for (String value : values) {
                profile.addRankProperty((String)key, value);
            }
        });
        this.rankProfileRegistry.add(profile);
    }
}

