/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.util.ArrayList;
import java.util.List;

public class ConstantTensorTransformer
extends ExpressionTransformer<RankProfileTransformContext> {
    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node, context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode node, RankProfileTransformContext context) {
        if (!node.getArguments().isEmpty() && !FeatureNames.isSimpleFeature(node.reference())) {
            return this.transformArguments(node, context);
        }
        return this.transformConstantReference(node, context);
    }

    private ExpressionNode transformArguments(ReferenceNode node, RankProfileTransformContext context) {
        List arguments = node.getArguments().expressions();
        ArrayList<ExpressionNode> transformedArguments = new ArrayList<ExpressionNode>(arguments.size());
        for (ExpressionNode argument : arguments) {
            transformedArguments.add(this.transform(argument, context));
        }
        return node.setArguments(transformedArguments);
    }

    private ExpressionNode transformConstantReference(ReferenceNode node, RankProfileTransformContext context) {
        String constantName = node.getName();
        Reference constantReference = node.reference();
        if (FeatureNames.isConstantFeature(constantReference)) {
            constantName = constantReference.simpleArgument().orElse(null);
        } else if (constantReference.isIdentifier()) {
            constantReference = FeatureNames.asConstantFeature(constantName);
        } else {
            return node;
        }
        Value value = (Value)context.constants().get(constantName);
        if (value == null || value.type().rank() == 0) {
            return node;
        }
        TensorValue tensorValue = (TensorValue)value;
        String tensorType = tensorValue.asTensor().type().toString();
        context.rankProperties().put(constantReference + ".value", tensorValue.toString());
        context.rankProperties().put(constantReference + ".type", tensorType);
        return new ReferenceNode(constantReference);
    }
}

