/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSearchCluster
extends AbstractConfigProducer<AbstractSearchCluster>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer {
    private Double queryTimeout;
    protected String clusterName;
    protected int index;
    private Double visibilityDelay = 0.0;
    private final List<String> documentNames = new ArrayList<String>();
    private final List<SchemaSpec> localSDS = new LinkedList<SchemaSpec>();

    public AbstractSearchCluster(AbstractConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public void addDocumentNames(Schema schema) {
        this.documentNames.add(schema.getDocument().getDocumentName().getName());
    }

    public List<String> getDocumentNames() {
        return this.documentNames;
    }

    public List<SchemaSpec> getLocalSDS() {
        return this.localSDS;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final String getIndexingModeName() {
        return this.getIndexingMode().getName();
    }

    public final boolean isStreaming() {
        return this.getIndexingMode() == IndexingMode.STREAMING;
    }

    public final AbstractSearchCluster setQueryTimeout(Double to) {
        this.queryTimeout = to;
        return this;
    }

    public final AbstractSearchCluster setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
        return this;
    }

    protected abstract IndexingMode getIndexingMode();

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public abstract int getRowBits();

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public abstract void getConfig(DocumentdbInfoConfig.Builder var1);

    public abstract void getConfig(IndexInfoConfig.Builder var1);

    public abstract void getConfig(IlscriptsConfig.Builder var1);

    public abstract void getConfig(RankProfilesConfig.Builder var1);

    public abstract void getConfig(AttributesConfig.Builder var1);

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    public static final class IndexingMode {
        public static final IndexingMode REALTIME = new IndexingMode("REALTIME");
        public static final IndexingMode STREAMING = new IndexingMode("STREAMING");
        private final String name;

        private IndexingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "indexingmode: " + this.name;
        }
    }

    public static final class SchemaSpec {
        private final Schema schema;
        private final UserConfigRepo userConfigRepo;

        public SchemaSpec(Schema schema, UserConfigRepo userConfigRepo) {
            this.schema = schema;
            this.userConfigRepo = userConfigRepo;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public UserConfigRepo getUserConfigs() {
            return this.userConfigRepo;
        }
    }
}

