/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configmodel.producers;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentmodel.DataTypeCollection;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedTemporaryType;
import com.yahoo.documentmodel.TemporaryUnknownType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.DocumentModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentManager {
    private boolean useV8GeoPositions = false;
    private boolean useV8DocManagerCfg = true;

    public DocumentManager useV8GeoPositions(boolean value) {
        this.useV8GeoPositions = value;
        return this;
    }

    public DocumentManager useV8DocManagerCfg(boolean value) {
        this.useV8DocManagerCfg = value;
        return this;
    }

    public DocumentmanagerConfig.Builder produce(DocumentModel model, DocumentmanagerConfig.Builder documentConfigBuilder) {
        if (this.useV8DocManagerCfg) {
            return this.produceDocTypes(model, documentConfigBuilder);
        }
        return this.produceDataTypes(model, documentConfigBuilder);
    }

    public DocumentmanagerConfig.Builder produceDataTypes(DocumentModel model, DocumentmanagerConfig.Builder documentConfigBuilder) {
        documentConfigBuilder.enablecompression(false);
        documentConfigBuilder.usev8geopositions(this.useV8GeoPositions);
        HashSet<DataType> handled = new HashSet<DataType>();
        for (NewDocumentType documentType : model.getDocumentManager().getTypes()) {
            this.buildConfig(documentType, documentConfigBuilder, handled);
            this.buildConfig(documentType.getAnnotations(), documentConfigBuilder);
            if (documentType == VespaDocumentType.INSTANCE || handled.contains(documentType)) continue;
            handled.add((DataType)documentType);
            DocumentmanagerConfig.Datatype.Builder dataTypeBuilder = new DocumentmanagerConfig.Datatype.Builder();
            documentConfigBuilder.datatype(dataTypeBuilder);
            this.buildConfig((DataType)documentType, dataTypeBuilder);
        }
        return documentConfigBuilder;
    }

    private void buildConfig(DataTypeCollection type, DocumentmanagerConfig.Builder documentConfigBuilder, Set<DataType> built) {
        ArrayList<DataType> todo = new ArrayList<DataType>(type.getTypes());
        Collections.sort(todo, (a, b) -> a.getName().equals(b.getName()) ? a.getId() - b.getId() : a.getName().compareTo(b.getName()));
        for (DataType dataType : todo) {
            if (built.contains(dataType)) continue;
            built.add(dataType);
            if (dataType instanceof TemporaryStructuredDataType) {
                throw new IllegalArgumentException("Can not create config for temporary data type: " + dataType.getName());
            }
            if (dataType instanceof TemporaryUnknownType) {
                throw new IllegalArgumentException("Can not create config for temporary data type: " + dataType.getName());
            }
            if (dataType instanceof OwnedTemporaryType) {
                throw new IllegalArgumentException("Can not create config for temporary data type: " + dataType.getName());
            }
            if (dataType.getId() >= 0 && dataType.getId() <= DataType.lastPredefinedDataTypeId()) continue;
            DocumentmanagerConfig.Datatype.Builder dataTypeBuilder = new DocumentmanagerConfig.Datatype.Builder();
            documentConfigBuilder.datatype(dataTypeBuilder);
            this.buildConfig(dataType, dataTypeBuilder);
        }
    }

    private void buildConfig(AnnotationType type, DocumentmanagerConfig.Annotationtype.Builder atb) {
        atb.id(type.getId()).name(type.getName());
        if (type.getDataType() != null) {
            atb.datatype(type.getDataType().getId());
        }
        if (!type.getInheritedTypes().isEmpty()) {
            for (AnnotationType inherited : type.getInheritedTypes()) {
                atb.inherits(new DocumentmanagerConfig.Annotationtype.Inherits.Builder().id(inherited.getId()));
            }
        }
    }

    private void buildConfig(Collection<AnnotationType> types, DocumentmanagerConfig.Builder builder) {
        for (AnnotationType type : types) {
            DocumentmanagerConfig.Annotationtype.Builder atb = new DocumentmanagerConfig.Annotationtype.Builder();
            this.buildConfig(type, atb);
            builder.annotationtype(atb);
        }
    }

    private void buildConfig(DataType type, DocumentmanagerConfig.Datatype.Builder builder) {
        builder.id(type.getId());
        if (type instanceof ArrayDataType) {
            CollectionDataType dt = (CollectionDataType)type;
            builder.arraytype(new DocumentmanagerConfig.Datatype.Arraytype.Builder().datatype(dt.getNestedType().getId()));
        } else if (type instanceof WeightedSetDataType) {
            WeightedSetDataType dt = (WeightedSetDataType)type;
            builder.weightedsettype(new DocumentmanagerConfig.Datatype.Weightedsettype.Builder().datatype(dt.getNestedType().getId()).createifnonexistant(dt.createIfNonExistent()).removeifzero(dt.removeIfZero()));
        } else if (type instanceof MapDataType) {
            MapDataType mtype = (MapDataType)type;
            builder.maptype(new DocumentmanagerConfig.Datatype.Maptype.Builder().keytype(mtype.getKeyType().getId()).valtype(mtype.getValueType().getId()));
        } else {
            if (type instanceof DocumentType) {
                throw new IllegalArgumentException("Can not create config for unadorned document type: " + type.getName());
            }
            if (type instanceof NewDocumentType) {
                NewDocumentType dt = (NewDocumentType)type;
                DocumentmanagerConfig.Datatype.Documenttype.Builder doc = new DocumentmanagerConfig.Datatype.Documenttype.Builder();
                builder.documenttype(doc);
                doc.name(dt.getName()).headerstruct(dt.getContentStruct().getId());
                for (NewDocumentType inherited : dt.getInherited()) {
                    doc.inherits(new DocumentmanagerConfig.Datatype.Documenttype.Inherits.Builder().name(inherited.getName()));
                }
                this.buildConfig(dt.getFieldSets(), doc);
                this.buildImportedFieldsConfig(dt.getImportedFieldNames(), doc);
            } else if (type instanceof StructDataType) {
                StructDataType structType = (StructDataType)type;
                DocumentmanagerConfig.Datatype.Structtype.Builder structBuilder = new DocumentmanagerConfig.Datatype.Structtype.Builder();
                builder.structtype(structBuilder);
                structBuilder.name(structType.getName());
                for (Field field : structType.getFieldsThisTypeOnly()) {
                    DocumentmanagerConfig.Datatype.Structtype.Field.Builder fieldBuilder = new DocumentmanagerConfig.Datatype.Structtype.Field.Builder();
                    structBuilder.field(fieldBuilder);
                    fieldBuilder.name(field.getName());
                    if (field.hasForcedId()) {
                        fieldBuilder.id(new DocumentmanagerConfig.Datatype.Structtype.Field.Id.Builder().id(field.getId()));
                    }
                    fieldBuilder.datatype(field.getDataType().getId());
                    if (!(field.getDataType() instanceof TensorDataType)) continue;
                    fieldBuilder.detailedtype(((TensorDataType)field.getDataType()).getTensorType().toString());
                }
                for (StructDataType inherited : structType.getInheritedTypes()) {
                    structBuilder.inherits(new DocumentmanagerConfig.Datatype.Structtype.Inherits.Builder().name(inherited.getName()));
                }
            } else if (type instanceof AnnotationReferenceDataType) {
                AnnotationReferenceDataType annotationRef = (AnnotationReferenceDataType)type;
                builder.annotationreftype(new DocumentmanagerConfig.Datatype.Annotationreftype.Builder().annotation(annotationRef.getAnnotationType().getName()));
            } else if (!(type instanceof TensorDataType)) {
                if (type instanceof NewDocumentReferenceDataType) {
                    NewDocumentReferenceDataType refType = (NewDocumentReferenceDataType)type;
                    if (refType.isTemporary()) {
                        throw new IllegalArgumentException("Still temporary: " + refType);
                    }
                    builder.referencetype(new DocumentmanagerConfig.Datatype.Referencetype.Builder().target_type_id(refType.getTargetTypeId()));
                } else {
                    throw new IllegalArgumentException("Can not create config for data type " + type + " of class " + type.getClass());
                }
            }
        }
    }

    private void buildConfig(Set<FieldSet> fieldSets, DocumentmanagerConfig.Datatype.Documenttype.Builder doc) {
        for (FieldSet builtinFs : fieldSets) {
            this.buildConfig(builtinFs, doc);
        }
    }

    private void buildConfig(FieldSet fs, DocumentmanagerConfig.Datatype.Documenttype.Builder doc) {
        doc.fieldsets(fs.getName(), new DocumentmanagerConfig.Datatype.Documenttype.Fieldsets.Builder().fields(fs.getFieldNames()));
    }

    private void buildImportedFieldsConfig(Collection<String> fieldNames, DocumentmanagerConfig.Datatype.Documenttype.Builder builder) {
        for (String fieldName : fieldNames) {
            DocumentmanagerConfig.Datatype.Documenttype.Importedfield.Builder ib = new DocumentmanagerConfig.Datatype.Documenttype.Importedfield.Builder();
            ib.name(fieldName);
            builder.importedfield(ib);
        }
    }

    public DocumentmanagerConfig.Builder produceDocTypes(DocumentModel model, DocumentmanagerConfig.Builder builder) {
        builder.usev8geopositions(this.useV8GeoPositions);
        HashMap<NewDocumentType.Name, NewDocumentType> produced = new HashMap<NewDocumentType.Name, NewDocumentType>();
        IdxMap indexMap = new IdxMap();
        for (NewDocumentType documentType : model.getDocumentManager().getTypes()) {
            this.docTypeInheritOrder(documentType, builder, produced, indexMap);
        }
        indexMap.verifyAllDone();
        return builder;
    }

    private void docTypeInheritOrder(NewDocumentType documentType, DocumentmanagerConfig.Builder builder, Map<NewDocumentType.Name, NewDocumentType> produced, IdxMap indexMap) {
        if (!produced.containsKey(documentType.getFullName())) {
            for (NewDocumentType inherited : documentType.getInherited()) {
                this.docTypeInheritOrder(inherited, builder, produced, indexMap);
            }
            this.docTypeBuild(documentType, builder, indexMap);
            produced.put(documentType.getFullName(), documentType);
        }
    }

    private static <T> List<T> sortedList(Collection<T> unsorted, Comparator<T> cmp) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(unsorted);
        list.sort(cmp);
        return list;
    }

    private void docTypeBuild(NewDocumentType documentType, DocumentmanagerConfig.Builder builder, IdxMap indexMap) {
        DocumentmanagerConfig.Doctype.Builder db = new DocumentmanagerConfig.Doctype.Builder();
        db.idx(indexMap.idxOf(documentType)).name(documentType.getName()).contentstruct(indexMap.idxOf(documentType.getContentStruct()));
        this.docTypeBuildFieldSets(documentType.getFieldSets(), db);
        this.docTypeBuildImportedFields(documentType.getImportedFieldNames(), db);
        for (NewDocumentType inherited : documentType.getInherited()) {
            db.inherits(b -> b.idx(indexMap.idxOf(inherited)));
        }
        this.docTypeBuildAnyType(documentType.getContentStruct(), db, indexMap);
        for (DataType dt : DocumentManager.sortedList(documentType.getAllTypes().getTypes(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnyType(dt, db, indexMap);
        }
        for (AnnotationType ann : DocumentManager.sortedList(documentType.getAnnotations(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnnotationType(ann, db, indexMap);
        }
        builder.doctype(db);
        indexMap.setDone(documentType);
    }

    private void docTypeBuildFieldSets(Set<FieldSet> fieldSets, DocumentmanagerConfig.Doctype.Builder db) {
        for (FieldSet fs : fieldSets) {
            this.docTypeBuildOneFieldSet(fs, db);
        }
    }

    private void docTypeBuildOneFieldSet(FieldSet fs, DocumentmanagerConfig.Doctype.Builder db) {
        db.fieldsets(fs.getName(), new DocumentmanagerConfig.Doctype.Fieldsets.Builder().fields(fs.getFieldNames()));
    }

    private void docTypeBuildAnnotationType(AnnotationType annotation, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        if (indexMap.isDone(annotation)) {
            return;
        }
        indexMap.setDone(annotation);
        DocumentmanagerConfig.Doctype.Annotationtype.Builder annBuilder = new DocumentmanagerConfig.Doctype.Annotationtype.Builder();
        annBuilder.idx(indexMap.idxOf(annotation)).name(annotation.getName()).internalid(annotation.getId());
        DataType nested = annotation.getDataType();
        if (nested != null) {
            annBuilder.datatype(indexMap.idxOf(nested));
            this.docTypeBuildAnyType(nested, builder, indexMap);
        }
        for (AnnotationType inherited : annotation.getInheritedTypes()) {
            annBuilder.inherits(inhBuilder -> inhBuilder.idx(indexMap.idxOf(inherited)));
        }
        builder.annotationtype(annBuilder);
    }

    private void docTypeBuildAnyType(DataType type, DocumentmanagerConfig.Doctype.Builder documentBuilder, IdxMap indexMap) {
        if (indexMap.isDone(type)) {
            return;
        }
        if (type instanceof NewDocumentType) {
            return;
        }
        if (type instanceof DocumentType && type.getId() == 8) {
            return;
        }
        indexMap.setDone(type);
        if (type instanceof TemporaryStructuredDataType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof TemporaryUnknownType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof OwnedTemporaryType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof StructDataType) {
            this.docTypeBuildOneType((StructDataType)type, documentBuilder, indexMap);
        } else if (type instanceof ArrayDataType) {
            this.docTypeBuildOneType((ArrayDataType)type, documentBuilder, indexMap);
        } else if (type instanceof WeightedSetDataType) {
            this.docTypeBuildOneType((WeightedSetDataType)type, documentBuilder, indexMap);
        } else if (type instanceof MapDataType) {
            this.docTypeBuildOneType((MapDataType)type, documentBuilder, indexMap);
        } else if (type instanceof AnnotationReferenceDataType) {
            this.docTypeBuildOneType((AnnotationReferenceDataType)type, documentBuilder, indexMap);
        } else if (type instanceof TensorDataType) {
            this.docTypeBuildOneType((TensorDataType)type, documentBuilder, indexMap);
        } else if (type instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType refType = (NewDocumentReferenceDataType)type;
            if (refType.isTemporary()) {
                throw new IllegalArgumentException("Still temporary: " + refType);
            }
            this.docTypeBuildOneType(refType, documentBuilder, indexMap);
        } else if (type instanceof PrimitiveDataType) {
            this.docTypeBuildOneType((PrimitiveDataType)type, documentBuilder, indexMap);
        } else {
            if (type instanceof DocumentType) {
                throw new IllegalArgumentException("Can not create config for unadorned document type: " + type.getName() + " id " + type.getId());
            }
            throw new IllegalArgumentException("Can not create config for data type " + type + " of class " + type.getClass());
        }
    }

    private void docTypeBuildImportedFields(Collection<String> fieldNames, DocumentmanagerConfig.Doctype.Builder builder) {
        for (String fieldName : fieldNames) {
            builder.importedfield(ib -> ib.name(fieldName));
        }
    }

    private void docTypeBuildOneType(StructDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DocumentmanagerConfig.Doctype.Structtype.Builder structBuilder = new DocumentmanagerConfig.Doctype.Structtype.Builder();
        structBuilder.idx(indexMap.idxOf(type)).name(type.getName());
        for (DataType inherited : type.getInheritedTypes()) {
            structBuilder.inherits(inheritBuilder -> inheritBuilder.type(indexMap.idxOf(inherited)));
            this.docTypeBuildAnyType(inherited, builder, indexMap);
        }
        for (Field field : type.getFieldsThisTypeOnly()) {
            DataType fieldType = field.getDataType();
            structBuilder.field(fieldBuilder -> fieldBuilder.name(field.getName()).internalid(field.getId()).type(indexMap.idxOf(fieldType)));
            this.docTypeBuildAnyType(fieldType, builder, indexMap);
        }
        builder.structtype(structBuilder);
    }

    private void docTypeBuildOneType(PrimitiveDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.primitivetype(primBuilder -> primBuilder.idx(indexMap.idxOf(type)).name(type.getName()));
    }

    private void docTypeBuildOneType(TensorDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        TensorType tt = type.getTensorType();
        String detailed = tt != null ? tt.toString() : "tensor";
        builder.tensortype(tensorBuilder -> tensorBuilder.idx(indexMap.idxOf(type)).detailedtype(detailed));
    }

    private void docTypeBuildOneType(ArrayDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.arraytype(arrayBuilder -> arrayBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(WeightedSetDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.wsettype(wsetBuilder -> wsetBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)).createifnonexistent(type.createIfNonExistent()).removeifzero(type.removeIfZero()));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(MapDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType keytype = type.getKeyType();
        DataType valtype = type.getValueType();
        builder.maptype(mapBuilder -> mapBuilder.idx(indexMap.idxOf(type)).keytype(indexMap.idxOf(keytype)).valuetype(indexMap.idxOf(valtype)));
        this.docTypeBuildAnyType(keytype, builder, indexMap);
        this.docTypeBuildAnyType(valtype, builder, indexMap);
    }

    private void docTypeBuildOneType(AnnotationReferenceDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.annotationref(arefBuilder -> arefBuilder.idx(indexMap.idxOf(type)).annotationtype(indexMap.idxOf(type.getAnnotationType())));
    }

    private void docTypeBuildOneType(NewDocumentReferenceDataType type, DocumentmanagerConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.documentref(docrefBuilder -> docrefBuilder.idx(indexMap.idxOf((Object)type)).targettype(indexMap.idxOf(type.getTargetType())));
    }

    private static class IdxMap {
        private Map<Integer, Boolean> doneMap = new HashMap<Integer, Boolean>();
        private Map<Object, Integer> map = new IdentityHashMap<Object, Integer>();

        private IdxMap() {
        }

        void add(Object someType) {
            assert (someType != null);
            int nextIdx = 10000 + this.map.size();
            this.map.computeIfAbsent(someType, k -> nextIdx);
        }

        int idxOf(Object someType) {
            DocumentType dt;
            if (someType instanceof DocumentType && (dt = (DocumentType)someType).getId() == 8) {
                return this.idxOf(VespaDocumentType.INSTANCE);
            }
            this.add(someType);
            return this.map.get(someType);
        }

        boolean isDone(Object someType) {
            return this.doneMap.computeIfAbsent(this.idxOf(someType), k -> false);
        }

        void setDone(Object someType) {
            assert (!this.isDone(someType));
            this.doneMap.put(this.idxOf(someType), true);
        }

        void verifyAllDone() {
            for (Map.Entry<Object, Integer> entry : this.map.entrySet()) {
                Object needed = entry.getKey();
                if (this.isDone(needed)) continue;
                throw new IllegalArgumentException("Could not generate config for all needed types, missing: " + needed + " of class " + needed.getClass());
            }
        }
    }
}

