/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.collections.Pair;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashMap;

public class SummaryNamesFieldCollisions
extends Processor {
    public SummaryNamesFieldCollisions(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        HashMap<String, Pair> fieldToClassAndSource = new HashMap<String, Pair>();
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            if ("default".equals(summary.getName())) continue;
            for (SummaryField summaryField : summary.getSummaryFields().values()) {
                if (summaryField.isImplicit()) continue;
                Pair prevClassAndSource = (Pair)fieldToClassAndSource.get(summaryField.getName());
                for (SummaryField.Source source : summaryField.getSources()) {
                    if (prevClassAndSource != null) {
                        String prevClass = (String)prevClassAndSource.getFirst();
                        String prevSource = (String)prevClassAndSource.getSecond();
                        if (prevClass.equals(summary.getName()) || prevSource.equals(source.getName())) continue;
                        throw new IllegalArgumentException("For " + this.schema + ", summary class '" + summary.getName() + "', summary field '" + summaryField.getName() + "': Can not use source '" + source.getName() + "' for this summary field, an equally named field in summary class '" + prevClass + "' uses a different source: '" + prevSource + "'.");
                    }
                    fieldToClassAndSource.put(summaryField.getName(), new Pair((Object)summary.getName(), (Object)source.getName()));
                }
            }
        }
    }
}

