/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedRankFunction;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ParsedRankProfile
extends ParsedBlock {
    private boolean ignoreDefaultRankFeatures = false;
    private Double rankScoreDropLimit = null;
    private Double termwiseLimit = null;
    private List<FeatureList> matchFeatures = new ArrayList<FeatureList>();
    private List<FeatureList> rankFeatures = new ArrayList<FeatureList>();
    private List<FeatureList> summaryFeatures = new ArrayList<FeatureList>();
    private Integer keepRankCount = null;
    private Integer minHitsPerThread = null;
    private Integer numSearchPartitions = null;
    private Integer numThreadsPerSearch = null;
    private Integer reRankCount = null;
    private RankProfile.MatchPhaseSettings matchPhaseSettings = null;
    private String firstPhaseExpression = null;
    private String inheritedSummaryFeatures = null;
    private String inheritedMatchFeatures = null;
    private String secondPhaseExpression = null;
    private Boolean strict = null;
    private final List<RankProfile.MutateOperation> mutateOperations = new ArrayList<RankProfile.MutateOperation>();
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, Boolean> fieldsRankFilter = new LinkedHashMap<String, Boolean>();
    private final Map<String, Integer> fieldsRankWeight = new LinkedHashMap<String, Integer>();
    private final Map<String, ParsedRankFunction> functions = new LinkedHashMap<String, ParsedRankFunction>();
    private final Map<String, String> fieldsRankType = new LinkedHashMap<String, String>();
    private final Map<String, List<String>> rankProperties = new LinkedHashMap<String, List<String>>();
    private final Map<String, Value> constants = new LinkedHashMap<String, Value>();

    ParsedRankProfile(String name) {
        super(name, "rank-profile");
    }

    boolean getIgnoreDefaultRankFeatures() {
        return this.ignoreDefaultRankFeatures;
    }

    Optional<Double> getRankScoreDropLimit() {
        return Optional.ofNullable(this.rankScoreDropLimit);
    }

    Optional<Double> getTermwiseLimit() {
        return Optional.ofNullable(this.termwiseLimit);
    }

    List<FeatureList> getMatchFeatures() {
        return List.copyOf(this.matchFeatures);
    }

    List<FeatureList> getRankFeatures() {
        return List.copyOf(this.rankFeatures);
    }

    List<FeatureList> getSummaryFeatures() {
        return List.copyOf(this.summaryFeatures);
    }

    Optional<Integer> getKeepRankCount() {
        return Optional.ofNullable(this.keepRankCount);
    }

    Optional<Integer> getMinHitsPerThread() {
        return Optional.ofNullable(this.minHitsPerThread);
    }

    Optional<Integer> getNumSearchPartitions() {
        return Optional.ofNullable(this.numSearchPartitions);
    }

    Optional<Integer> getNumThreadsPerSearch() {
        return Optional.ofNullable(this.numThreadsPerSearch);
    }

    Optional<Integer> getReRankCount() {
        return Optional.ofNullable(this.reRankCount);
    }

    Optional<RankProfile.MatchPhaseSettings> getMatchPhaseSettings() {
        return Optional.ofNullable(this.matchPhaseSettings);
    }

    Optional<String> getFirstPhaseExpression() {
        return Optional.ofNullable(this.firstPhaseExpression);
    }

    Optional<String> getInheritedMatchFeatures() {
        return Optional.ofNullable(this.inheritedMatchFeatures);
    }

    List<ParsedRankFunction> getFunctions() {
        return List.copyOf(this.functions.values());
    }

    List<RankProfile.MutateOperation> getMutateOperations() {
        return List.copyOf(this.mutateOperations);
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    Map<String, Boolean> getFieldsWithRankFilter() {
        return Map.copyOf(this.fieldsRankFilter);
    }

    Map<String, Integer> getFieldsWithRankWeight() {
        return Map.copyOf(this.fieldsRankWeight);
    }

    Map<String, String> getFieldsWithRankType() {
        return Map.copyOf(this.fieldsRankType);
    }

    Map<String, List<String>> getRankProperties() {
        return Map.copyOf(this.rankProperties);
    }

    Map<String, Value> getConstants() {
        return Map.copyOf(this.constants);
    }

    Optional<String> getInheritedSummaryFeatures() {
        return Optional.ofNullable(this.inheritedSummaryFeatures);
    }

    Optional<String> getSecondPhaseExpression() {
        return Optional.ofNullable(this.secondPhaseExpression);
    }

    Optional<Boolean> isStrict() {
        return Optional.ofNullable(this.strict);
    }

    void addSummaryFeatures(FeatureList features) {
        this.summaryFeatures.add(features);
    }

    void addMatchFeatures(FeatureList features) {
        this.matchFeatures.add(features);
    }

    void addRankFeatures(FeatureList features) {
        this.rankFeatures.add(features);
    }

    void inherit(String other) {
        this.inherited.add(other);
    }

    void setInheritedSummaryFeatures(String other) {
        this.verifyThat(this.inheritedSummaryFeatures == null, "already inherits summary-features", new Object[0]);
        this.inheritedSummaryFeatures = other;
    }

    void addConstant(String name, Value value) {
        this.verifyThat(!this.constants.containsKey(name), "already has constant", name);
        this.constants.put(name, value);
    }

    void addConstantTensor(String name, TensorValue value) {
        this.verifyThat(!this.constants.containsKey(name), "already has constant", name);
        this.constants.put(name, (Value)value);
    }

    void addFieldRankFilter(String field, boolean filter) {
        this.fieldsRankFilter.put(field, filter);
    }

    void addFieldRankType(String field, String type) {
        this.verifyThat(!this.fieldsRankType.containsKey(field), "already has rank type for field", field);
        this.fieldsRankType.put(field, type);
    }

    void addFieldRankWeight(String field, int weight) {
        this.verifyThat(!this.fieldsRankType.containsKey(field), "already has weight for field", field);
        this.fieldsRankWeight.put(field, weight);
    }

    ParsedRankFunction addOrReplaceFunction(ParsedRankFunction func) {
        return this.functions.put(func.name(), func);
    }

    void addMutateOperation(RankProfile.MutateOperation.Phase phase, String attrName, String operation) {
        this.mutateOperations.add(new RankProfile.MutateOperation(phase, attrName, operation));
    }

    void addRankProperty(String key, String value) {
        List values = this.rankProperties.computeIfAbsent(key, k -> new ArrayList());
        values.add(value);
    }

    void setFirstPhaseRanking(String expression) {
        this.verifyThat(this.firstPhaseExpression == null, "already has first-phase expression", new Object[0]);
        this.firstPhaseExpression = expression;
    }

    void setIgnoreDefaultRankFeatures(boolean value) {
        this.ignoreDefaultRankFeatures = value;
    }

    void setInheritedMatchFeatures(String other) {
        this.inheritedMatchFeatures = other;
    }

    void setKeepRankCount(int count) {
        this.verifyThat(this.keepRankCount == null, "already has rerank-count", new Object[0]);
        this.keepRankCount = count;
    }

    void setMatchPhaseSettings(RankProfile.MatchPhaseSettings settings) {
        this.verifyThat(this.matchPhaseSettings == null, "already has match-phase", new Object[0]);
        this.matchPhaseSettings = settings;
    }

    void setMinHitsPerThread(int minHits) {
        this.verifyThat(this.minHitsPerThread == null, "already has min-hits-per-thread", new Object[0]);
        this.minHitsPerThread = minHits;
    }

    void setNumSearchPartitions(int numParts) {
        this.verifyThat(this.numSearchPartitions == null, "already has num-search-partitions", new Object[0]);
        this.numSearchPartitions = numParts;
    }

    void setNumThreadsPerSearch(int threads) {
        this.verifyThat(this.numThreadsPerSearch == null, "already has num-threads-per-search", new Object[0]);
        this.numThreadsPerSearch = threads;
    }

    void setRankScoreDropLimit(double limit) {
        this.verifyThat(this.rankScoreDropLimit == null, "already has rank-score-drop-limit", new Object[0]);
        this.rankScoreDropLimit = limit;
    }

    void setRerankCount(int count) {
        this.verifyThat(this.reRankCount == null, "already has rerank-count", new Object[0]);
        this.reRankCount = count;
    }

    void setSecondPhaseRanking(String expression) {
        this.verifyThat(this.secondPhaseExpression == null, "already has second-phase expression", new Object[0]);
        this.secondPhaseExpression = expression;
    }

    void setStrict(boolean strict) {
        this.verifyThat(this.strict == null, "already has strict", new Object[0]);
        this.strict = strict;
    }

    void setTermwiseLimit(double limit) {
        this.verifyThat(this.termwiseLimit == null, "already has termwise-limit", new Object[0]);
        this.termwiseLimit = limit;
    }
}

