/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.OwnedStructDataType;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.searchdefinition.parser.ParsedAnnotation;
import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedField;
import com.yahoo.searchdefinition.parser.ParsedFieldSet;
import com.yahoo.searchdefinition.parser.ParsedSchema;
import com.yahoo.searchdefinition.parser.ParsedStruct;
import com.yahoo.searchdefinition.parser.ParsedType;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConvertParsedTypes {
    private final List<ParsedSchema> orderedInput;
    private final DocumentTypeManager docMan;
    private Map<String, DocumentType> documentsFromSchemas = new HashMap<String, DocumentType>();
    private Map<String, StructDataType> structsFromSchemas = new HashMap<String, StructDataType>();
    private Map<String, SDAnnotationType> annotationsFromSchemas = new HashMap<String, SDAnnotationType>();

    ConvertParsedTypes(List<ParsedSchema> input) {
        this.orderedInput = input;
        this.docMan = new DocumentTypeManager();
    }

    public ConvertParsedTypes(List<ParsedSchema> input, DocumentTypeManager docMan) {
        this.orderedInput = input;
        this.docMan = docMan;
    }

    public void convert(boolean andRegister) {
        this.startDataTypes();
        this.fillDataTypes();
        if (andRegister) {
            this.registerDataTypes();
        }
    }

    private void startDataTypes() {
        for (ParsedSchema schema : this.orderedInput) {
            String name = schema.getDocument().name();
            this.documentsFromSchemas.put(name, new DocumentType(name));
        }
        for (ParsedSchema schema : this.orderedInput) {
            ParsedDocument doc = schema.getDocument();
            for (ParsedStruct struct : doc.getStructs()) {
                String structId = doc.name() + "->" + struct.name();
                OwnedStructDataType dt = new OwnedStructDataType(struct.name(), doc.name());
                this.structsFromSchemas.put(structId, dt);
            }
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                String annId = doc.name() + "->" + annotation.name();
                SDAnnotationType at = new SDAnnotationType(annotation.name());
                this.annotationsFromSchemas.put(annId, at);
                for (String inherit : annotation.getInherited()) {
                    at.inherit(inherit);
                }
                Optional<ParsedStruct> withStruct = annotation.getStruct();
                if (!withStruct.isPresent()) continue;
                ParsedStruct struct = withStruct.get();
                String structId = doc.name() + "->" + struct.name();
                StructDataType old = this.structsFromSchemas.put(structId, new OwnedStructDataType(struct.name(), doc.name()));
                assert (old == null);
            }
        }
    }

    void fillAnnotationStruct(ParsedAnnotation annotation) {
        Optional<ParsedStruct> withStruct = annotation.getStruct();
        if (withStruct.isPresent()) {
            ParsedDocument doc = annotation.getOwnerDoc();
            StructDataType toFill = this.findStructFromParsed(withStruct.get());
            for (ParsedField field : withStruct.get().getFields()) {
                DataType t = this.resolveFromContext(field.getType(), doc);
                Field f = field.hasIdOverride() ? new Field(field.name(), field.idOverride(), t) : new Field(field.name(), t);
                toFill.addField(f);
            }
            for (ParsedAnnotation parent : annotation.getResolvedInherits()) {
                parent.getStruct().ifPresent(ps -> toFill.inherit(this.findStructFromParsed((ParsedStruct)ps)));
            }
            SDAnnotationType at = this.findAnnotationFromParsed(annotation);
            at.setDataType((DataType)toFill);
        }
    }

    private void fillDataTypes() {
        for (ParsedSchema schema : this.orderedInput) {
            Field f;
            DataType t;
            String name;
            ParsedDocument doc = schema.getDocument();
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                SDAnnotationType at = this.findAnnotationFromParsed(annotation);
                for (ParsedAnnotation parsedAnnotation : annotation.getResolvedInherits()) {
                    at.inherit(this.findAnnotationFromParsed(parsedAnnotation));
                }
                this.fillAnnotationStruct(annotation);
            }
            for (ParsedStruct struct : doc.getStructs()) {
                StructDataType toFill = this.findStructFromParsed(struct);
                for (ParsedField parsedField : struct.getFields()) {
                    if (parsedField.hasIdOverride()) continue;
                    DataType t2 = this.resolveFromContext(parsedField.getType(), doc);
                    Field f2 = new Field(parsedField.name(), t2);
                    toFill.addField(f2);
                }
                for (ParsedField parsedField : struct.getFields()) {
                    if (!parsedField.hasIdOverride()) continue;
                    DataType t2 = this.resolveFromContext(parsedField.getType(), doc);
                    Field f2 = new Field(parsedField.name(), parsedField.idOverride(), t2);
                    toFill.addField(f2);
                }
                for (ParsedStruct parsedStruct : struct.getResolvedInherits()) {
                    StructDataType parent = this.findStructFromParsed(parsedStruct);
                    for (Field field : toFill.getFields()) {
                        if (!parent.hasField(field)) continue;
                        for (StructDataType base : parent.getInheritedTypes()) {
                            if (!base.hasField(field)) continue;
                            parent = base;
                        }
                        throw new IllegalArgumentException("In document " + doc.name() + ": struct " + struct.name() + " cannot inherit from " + parent.getName() + " and redeclare field " + field.getName());
                    }
                    toFill.inherit(parent);
                }
            }
            DocumentType docToFill = this.documentsFromSchemas.get(doc.name());
            HashMap<String, List<Object>> fieldSets = new HashMap<String, List<Object>>();
            ArrayList<String> inDocFields = new ArrayList<String>();
            for (ParsedField parsedField : doc.getFields()) {
                name = parsedField.name();
                t = this.resolveFromContext(parsedField.getType(), doc);
                f = new Field(parsedField.name(), t);
                docToFill.addField(f);
                if (parsedField.hasIdOverride()) {
                    f.setId(parsedField.idOverride(), docToFill);
                }
                inDocFields.add(name);
            }
            fieldSets.put("[document]", inDocFields);
            for (ParsedField parsedField : schema.getFields()) {
                name = parsedField.name();
                if (docToFill.hasField(name)) continue;
                t = this.resolveFromContext(parsedField.getType(), doc);
                f = new Field(name, t);
                docToFill.addField(f);
            }
            for (ParsedFieldSet parsedFieldSet : schema.getFieldSets()) {
                fieldSets.put(parsedFieldSet.name(), parsedFieldSet.getFieldNames());
            }
            docToFill.addFieldSets(fieldSets);
            for (String string : doc.getInherited()) {
                docToFill.inherit(this.findDocFromSchemas(string));
            }
        }
    }

    private StructDataType findStructFromParsed(ParsedStruct resolved) {
        String structId = resolved.getOwnerName() + "->" + resolved.name();
        StructDataType struct = this.structsFromSchemas.get(structId);
        assert (struct != null);
        return struct;
    }

    private StructDataType findStructFromSchemas(String name, ParsedDocument context) {
        ParsedStruct resolved = context.findParsedStruct(name);
        if (resolved == null) {
            throw new IllegalArgumentException("no struct named " + name + " in context " + context);
        }
        return this.findStructFromParsed(resolved);
    }

    private SDAnnotationType findAnnotationFromSchemas(String name, ParsedDocument context) {
        ParsedAnnotation resolved = context.findParsedAnnotation(name);
        String annotationId = resolved.getOwnerName() + "->" + resolved.name();
        SDAnnotationType annotation = this.annotationsFromSchemas.get(annotationId);
        if (annotation == null) {
            throw new IllegalArgumentException("no annotation named " + name + " in context " + context);
        }
        return annotation;
    }

    private SDAnnotationType findAnnotationFromParsed(ParsedAnnotation resolved) {
        String annotationId = resolved.getOwnerName() + "->" + resolved.name();
        SDAnnotationType annotation = this.annotationsFromSchemas.get(annotationId);
        if (annotation == null) {
            throw new IllegalArgumentException("no annotation " + resolved.name() + " in " + resolved.getOwnerName());
        }
        return annotation;
    }

    private DataType createArray(ParsedType pType, ParsedDocument context) {
        DataType nested = this.resolveFromContext(pType.nestedType(), context);
        return DataType.getArray((DataType)nested);
    }

    private DataType createWset(ParsedType pType, ParsedDocument context) {
        DataType nested = this.resolveFromContext(pType.nestedType(), context);
        boolean cine = pType.getCreateIfNonExistent();
        boolean riz = pType.getRemoveIfZero();
        return new WeightedSetDataType(nested, cine, riz);
    }

    private DataType createMap(ParsedType pType, ParsedDocument context) {
        DataType kt = this.resolveFromContext(pType.mapKeyType(), context);
        DataType vt = this.resolveFromContext(pType.mapValueType(), context);
        return DataType.getMap((DataType)kt, (DataType)vt);
    }

    private DocumentType findDocFromSchemas(String name) {
        DocumentType dt = this.documentsFromSchemas.get(name);
        if (dt == null) {
            throw new IllegalArgumentException("missing document type for: " + name);
        }
        return dt;
    }

    private DataType createAnnRef(ParsedType pType, ParsedDocument context) {
        SDAnnotationType annotation = this.findAnnotationFromSchemas(pType.getNameOfReferencedAnnotation(), context);
        return new AnnotationReferenceDataType((AnnotationType)annotation);
    }

    private DataType createDocRef(ParsedType pType) {
        ParsedType ref = pType.getReferencedDocumentType();
        assert (ref.getVariant() == ParsedType.Variant.DOCUMENT);
        return new NewDocumentReferenceDataType(this.findDocFromSchemas(ref.name()));
    }

    private DataType getBuiltinType(String name) {
        switch (name) {
            case "bool": {
                return DataType.BOOL;
            }
            case "byte": {
                return DataType.BYTE;
            }
            case "int": {
                return DataType.INT;
            }
            case "long": {
                return DataType.LONG;
            }
            case "string": {
                return DataType.STRING;
            }
            case "float": {
                return DataType.FLOAT;
            }
            case "double": {
                return DataType.DOUBLE;
            }
            case "uri": {
                return DataType.URI;
            }
            case "predicate": {
                return DataType.PREDICATE;
            }
            case "raw": {
                return DataType.RAW;
            }
            case "tag": {
                return DataType.TAG;
            }
            case "float16": {
                return DataType.FLOAT16;
            }
        }
        throw new IllegalArgumentException("Unknown builtin type: " + name);
    }

    private DataType resolveFromContext(ParsedType pType, ParsedDocument context) {
        String name = pType.name();
        switch (pType.getVariant()) {
            case NONE: {
                return DataType.NONE;
            }
            case BUILTIN: {
                return this.getBuiltinType(name);
            }
            case POSITION: {
                return PositionDataType.INSTANCE;
            }
            case ARRAY: {
                return this.createArray(pType, context);
            }
            case WSET: {
                return this.createWset(pType, context);
            }
            case MAP: {
                return this.createMap(pType, context);
            }
            case TENSOR: {
                return DataType.getTensor((TensorType)pType.getTensorType());
            }
            case DOC_REFERENCE: {
                return this.createDocRef(pType);
            }
            case ANN_REFERENCE: {
                return this.createAnnRef(pType, context);
            }
            case DOCUMENT: {
                return this.findDocFromSchemas(name);
            }
            case STRUCT: {
                return this.findStructFromSchemas(name, context);
            }
        }
        ParsedStruct found = context.findParsedStruct(name);
        if (found != null) {
            pType.setVariant(ParsedType.Variant.STRUCT);
            return this.findStructFromSchemas(name, context);
        }
        if (this.documentsFromSchemas.containsKey(name)) {
            pType.setVariant(ParsedType.Variant.DOCUMENT);
            return this.findDocFromSchemas(name);
        }
        throw new IllegalArgumentException("unknown type named '" + name + "' in context " + context);
    }

    private void registerDataTypes() {
        for (DataType dataType : this.structsFromSchemas.values()) {
            this.docMan.register(dataType);
        }
        for (DocumentType documentType : this.documentsFromSchemas.values()) {
            this.docMan.register((DataType)documentType);
        }
        for (SDAnnotationType sDAnnotationType : this.annotationsFromSchemas.values()) {
            this.docMan.getAnnotationTypeRegistry().register((AnnotationType)sDAnnotationType);
        }
    }

    public TypeResolver makeContext(ParsedDocument doc) {
        return new TypeResolver(doc);
    }

    public class TypeResolver {
        private final ParsedDocument context;

        public DataType resolveType(ParsedType parsed) {
            return ConvertParsedTypes.this.resolveFromContext(parsed, this.context);
        }

        public DataType resolveStruct(ParsedStruct parsed) {
            String structId = this.context.name() + "->" + parsed.name();
            StructDataType r = ConvertParsedTypes.this.structsFromSchemas.get(structId);
            if (r == null) {
                throw new IllegalArgumentException("no datatype found for struct: " + structId);
            }
            return r;
        }

        public SDAnnotationType resolveAnnotation(String name) {
            return ConvertParsedTypes.this.findAnnotationFromSchemas(name, this.context);
        }

        TypeResolver(ParsedDocument context) {
            this.context = context;
        }
    }
}

