/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.MatchAlgorithm;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import java.util.Map;

public class NoPrefixForIndexes
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        for (AbstractSearchCluster cluster : model.getSearchClusters()) {
            if (!(cluster instanceof IndexedSearchCluster)) continue;
            IndexedSearchCluster sc = (IndexedSearchCluster)cluster;
            for (DocumentDatabase docDb : sc.getDocumentDbs()) {
                DerivedConfiguration sdConfig = docDb.getDerivedConfiguration();
                Schema schema = sdConfig.getSearch();
                for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
                    if (!immutableSDField.doesIndexing()) continue;
                    if (immutableSDField.getMatching().getAlgorithm().equals((Object)MatchAlgorithm.PREFIX)) {
                        this.failField(schema, immutableSDField);
                    }
                    for (Map.Entry<String, Index> e : immutableSDField.getIndices().entrySet()) {
                        if (!e.getValue().isPrefix()) continue;
                        this.failField(schema, immutableSDField);
                    }
                }
            }
        }
    }

    private void failField(Schema schema, ImmutableSDField field) {
        throw new IllegalArgumentException("For " + schema + ", field '" + field.getName() + "': match/index:prefix is not supported for indexes.");
    }
}

