/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ReferenceFieldsProcessor
extends Processor {
    public ReferenceFieldsProcessor(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.clearSummaryAttributeAspectForConcreteFields();
        this.clearSummaryAttributeAspectForExplicitSummaryFields();
    }

    private void clearSummaryAttributeAspectForExplicitSummaryFields() {
        for (DocumentSummary docSum : this.schema.getSummaries().values()) {
            docSum.getSummaryFields().values().stream().filter(summaryField -> summaryField.getDataType() instanceof NewDocumentReferenceDataType).forEach(summaryField -> summaryField.setTransform(SummaryTransform.NONE));
        }
    }

    private void clearSummaryAttributeAspectForConcreteFields() {
        for (SDField field : this.schema.allConcreteFields()) {
            if (!(field.getDataType() instanceof NewDocumentReferenceDataType)) continue;
            this.removeFromAttributePrefetchSummaryClass(field);
            this.clearSummaryTransformOnSummaryFields(field);
        }
    }

    private void removeFromAttributePrefetchSummaryClass(SDField field) {
        DocumentSummary summary = this.schema.getSummariesInThis().get("attributeprefetch");
        if (summary != null) {
            summary.remove(field.getName());
        }
    }

    private void clearSummaryTransformOnSummaryFields(SDField field) {
        this.schema.getSummaryFields(field).forEach(summaryField -> summaryField.setTransform(SummaryTransform.NONE));
    }
}

