/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.parser.DictionaryOption;
import com.yahoo.searchdefinition.parser.ParsedAttribute;
import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedIndex;
import com.yahoo.searchdefinition.parser.ParsedIndexingOp;
import com.yahoo.searchdefinition.parser.ParsedMatchSettings;
import com.yahoo.searchdefinition.parser.ParsedSorting;
import com.yahoo.searchdefinition.parser.ParsedSummaryField;
import com.yahoo.searchdefinition.parser.ParsedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ParsedField
extends ParsedBlock {
    private ParsedType type;
    private boolean hasBolding = false;
    private boolean isFilter = false;
    private int overrideId = 0;
    private boolean isLiteral = false;
    private boolean isNormal = false;
    private Integer weight;
    private String normalizing = null;
    private final ParsedMatchSettings matchInfo = new ParsedMatchSettings();
    private Stemming stemming = null;
    private ParsedIndexingOp indexingOp = null;
    private ParsedSorting sortSettings = null;
    private final Map<String, ParsedAttribute> attributes = new LinkedHashMap<String, ParsedAttribute>();
    private final Map<String, ParsedIndex> fieldIndexes = new LinkedHashMap<String, ParsedIndex>();
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private final Map<String, String> rankTypes = new LinkedHashMap<String, String>();
    private final Map<String, ParsedField> structFields = new LinkedHashMap<String, ParsedField>();
    private final Map<String, ParsedSummaryField> summaryFields = new LinkedHashMap<String, ParsedSummaryField>();
    private final List<DictionaryOption> dictionaryOptions = new ArrayList<DictionaryOption>();
    private final List<String> queryCommands = new ArrayList<String>();

    ParsedField(String name, ParsedType type) {
        super(name, "field");
        this.type = type;
    }

    ParsedType getType() {
        return this.type;
    }

    boolean hasBolding() {
        return this.hasBolding;
    }

    boolean hasFilter() {
        return this.isFilter;
    }

    boolean hasLiteral() {
        return this.isLiteral;
    }

    boolean hasNormal() {
        return this.isNormal;
    }

    boolean hasIdOverride() {
        return this.overrideId != 0;
    }

    int idOverride() {
        return this.overrideId;
    }

    List<DictionaryOption> getDictionaryOptions() {
        return List.copyOf(this.dictionaryOptions);
    }

    List<ParsedAttribute> getAttributes() {
        return List.copyOf(this.attributes.values());
    }

    List<ParsedIndex> getIndexes() {
        return List.copyOf(this.fieldIndexes.values());
    }

    List<ParsedSummaryField> getSummaryFields() {
        return List.copyOf(this.summaryFields.values());
    }

    List<ParsedField> getStructFields() {
        return List.copyOf(this.structFields.values());
    }

    List<String> getAliases() {
        return List.copyOf(this.aliases.keySet());
    }

    List<String> getQueryCommands() {
        return List.copyOf(this.queryCommands);
    }

    String lookupAliasedFrom(String alias) {
        return this.aliases.get(alias);
    }

    ParsedMatchSettings matchSettings() {
        return this.matchInfo;
    }

    Optional<Integer> getWeight() {
        return Optional.ofNullable(this.weight);
    }

    Optional<Stemming> getStemming() {
        return Optional.ofNullable(this.stemming);
    }

    Optional<String> getNormalizing() {
        return Optional.ofNullable(this.normalizing);
    }

    Optional<ParsedIndexingOp> getIndexing() {
        return Optional.ofNullable(this.indexingOp);
    }

    Optional<ParsedSorting> getSorting() {
        return Optional.ofNullable(this.sortSettings);
    }

    Map<String, String> getRankTypes() {
        return Map.copyOf(this.rankTypes);
    }

    ParsedSummaryField summaryFieldFor(String name) {
        if (this.summaryFields.containsKey(name)) {
            return this.summaryFields.get(name);
        }
        ParsedSummaryField sf = new ParsedSummaryField(name, this.getType());
        this.summaryFields.put(name, sf);
        return sf;
    }

    ParsedSummaryField summaryFieldFor(String name, ParsedType type) {
        if (this.summaryFields.containsKey(name)) {
            ParsedSummaryField sf = this.summaryFields.get(name);
            if (sf.getType() == null) {
                sf.setType(type);
            } else {
                String oldName = sf.getType().name();
                String newName = type.name();
                this.verifyThat(newName.equals(oldName), "type mismatch for summary field", name, ":", oldName, "/", newName);
            }
            return sf;
        }
        ParsedSummaryField sf = new ParsedSummaryField(name, type);
        this.summaryFields.put(name, sf);
        return sf;
    }

    void addAlias(String from, String to) {
        this.verifyThat(!this.aliases.containsKey(to), "already has alias", to);
        this.aliases.put(to, from);
    }

    void addIndex(ParsedIndex index) {
        String idxName = index.name();
        this.verifyThat(!this.fieldIndexes.containsKey(idxName), "already has index", idxName);
        this.fieldIndexes.put(idxName, index);
    }

    void addRankType(String index, String rankType) {
        this.rankTypes.put(index, rankType);
    }

    void dictionary(DictionaryOption option) {
        this.dictionaryOptions.add(option);
    }

    void setBolding(boolean value) {
        this.hasBolding = value;
    }

    void setFilter(boolean value) {
        this.isFilter = value;
    }

    void setId(int id) {
        this.overrideId = id;
    }

    void setLiteral(boolean value) {
        this.isLiteral = value;
    }

    void setNormal(boolean value) {
        this.isNormal = value;
    }

    void setNormalizing(String value) {
        this.normalizing = value;
    }

    void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    void setWeight(int weight) {
        this.weight = weight;
    }

    ParsedAttribute attributeFor(String attrName) {
        return this.attributes.computeIfAbsent(attrName, n -> new ParsedAttribute((String)n));
    }

    void setIndexingOperation(ParsedIndexingOp idxOp) {
        this.verifyThat(this.indexingOp == null, "already has indexing", new Object[0]);
        this.indexingOp = idxOp;
    }

    ParsedSorting sortInfo() {
        if (this.sortSettings == null) {
            this.sortSettings = new ParsedSorting(this.name(), "field.sorting");
        }
        return this.sortSettings;
    }

    void addQueryCommand(String command) {
        this.queryCommands.add(command);
    }

    void addStructField(ParsedField structField) {
        String fieldName = structField.name();
        this.verifyThat(!this.structFields.containsKey(fieldName), "already has struct-field", fieldName);
        this.structFields.put(fieldName, structField);
    }

    void addSummaryField(ParsedSummaryField summaryField) {
        String fieldName = summaryField.name();
        this.verifyThat(!this.summaryFields.containsKey(fieldName), "already has summary field", fieldName);
        if (summaryField.getType() == null) {
            summaryField.setType(this.getType());
        }
        this.summaryFields.put(fieldName, summaryField);
    }
}

