/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.DataTypeName;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDDocumentType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchOrderer {
    private final Map<DataTypeName, Schema> documentNameToSearch = new HashMap<DataTypeName, Schema>();

    public List<Schema> order(List<Schema> unordered) {
        unordered.sort(Comparator.comparing(Schema::getName));
        this.indexOnDocumentName(unordered);
        ArrayList<Schema> ordered = new ArrayList<Schema>(unordered.size());
        ArrayList<Schema> moveOutwards = new ArrayList<Schema>();
        for (Schema schema : unordered) {
            if (this.allDependenciesAlreadyEmitted(ordered, schema)) {
                this.addOrdered(ordered, schema, moveOutwards);
                continue;
            }
            moveOutwards.add(schema);
        }
        ordered.addAll(moveOutwards);
        this.documentNameToSearch.clear();
        return ordered;
    }

    private void addOrdered(List<Schema> ordered, Schema schema, List<Schema> moveOutwards) {
        Schema eligibleMove;
        ordered.add(schema);
        do {
            if ((eligibleMove = this.removeFirstEntryWithFullyEmittedDependencies(moveOutwards, ordered)) == null) continue;
            ordered.add(eligibleMove);
        } while (eligibleMove != null);
    }

    private Schema removeFirstEntryWithFullyEmittedDependencies(List<Schema> moveOutwards, List<Schema> ordered) {
        for (Schema move : moveOutwards) {
            if (!this.allDependenciesAlreadyEmitted(ordered, move)) continue;
            moveOutwards.remove(move);
            return move;
        }
        return null;
    }

    private boolean allDependenciesAlreadyEmitted(List<Schema> alreadyOrdered, Schema schema) {
        if (schema.getDocument() == null) {
            return true;
        }
        SDDocumentType document = schema.getDocument();
        return this.allInheritedDependenciesEmitted(alreadyOrdered, document) && SearchOrderer.allReferenceDependenciesEmitted(alreadyOrdered, document);
    }

    private boolean allInheritedDependenciesEmitted(List<Schema> alreadyOrdered, SDDocumentType document) {
        for (SDDocumentType sdoc : document.getInheritedTypes()) {
            Schema inheritedSchema;
            DataTypeName inheritedName = sdoc.getDocumentName();
            if ("document".equals(inheritedName.getName()) || alreadyOrdered.contains(inheritedSchema = this.documentNameToSearch.get(inheritedName))) continue;
            return false;
        }
        return true;
    }

    private static boolean allReferenceDependenciesEmitted(List<Schema> alreadyOrdered, SDDocumentType document) {
        DocumentReferences documentReferences = document.getDocumentReferences().orElseThrow(() -> new IllegalStateException("Missing document references. Should have been processed by now."));
        return documentReferences.stream().map(Map.Entry::getValue).map(DocumentReference::targetSearch).allMatch(alreadyOrdered::contains);
    }

    private void indexOnDocumentName(List<Schema> schemas) {
        this.documentNameToSearch.clear();
        for (Schema schema : schemas) {
            if (schema.getDocument() == null) continue;
            this.documentNameToSearch.put(schema.getDocument().getDocumentName(), schema);
        }
    }
}

