/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.config.DocumenttypesConfig;
import com.yahoo.searchdefinition.ApplicationBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.configmodel.producers.DocumentManager;
import com.yahoo.vespa.configmodel.producers.DocumentTypes;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Deriver {
    public static ApplicationBuilder getSchemaBuilder(List<String> schemas) {
        ApplicationBuilder builder = new ApplicationBuilder();
        try {
            for (String schema : schemas) {
                builder.addSchemaFile(schema);
            }
        }
        catch (ParseException | IOException e) {
            throw new IllegalArgumentException(e);
        }
        builder.build(true);
        return builder;
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(String sd) {
        return Deriver.getDocumentManagerConfig(Collections.singletonList(sd));
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(List<String> schemas) {
        return new DocumentManager().produce(Deriver.getSchemaBuilder(schemas).getModel(), new DocumentmanagerConfig.Builder());
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(List<String> schemas, boolean useV8DocManagerCfg) {
        return new DocumentManager().useV8DocManagerCfg(useV8DocManagerCfg).produce(Deriver.getSchemaBuilder(schemas).getModel(), new DocumentmanagerConfig.Builder());
    }

    public static DocumenttypesConfig.Builder getDocumentTypesConfig(String schema) {
        return Deriver.getDocumentTypesConfig(Collections.singletonList(schema));
    }

    public static DocumenttypesConfig.Builder getDocumentTypesConfig(List<String> schemas) {
        return new DocumentTypes().produce(Deriver.getSchemaBuilder(schemas).getModel(), new DocumenttypesConfig.Builder());
    }
}

