/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;

public class StreamingSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
RankProfilesConfig.Producer,
VsmsummaryConfig.Producer,
VsmfieldsConfig.Producer,
SummarymapConfig.Producer,
SummaryConfig.Producer {
    private final String storageRouteSpec;
    private final AttributesProducer attributesConfig;
    private final String docTypeName;
    private DerivedConfiguration sdConfig = null;

    public StreamingSearchCluster(AbstractConfigProducer<SearchCluster> parent, String clusterName, int index, String docTypeName, String storageRouteSpec) {
        super(parent, clusterName, index);
        this.attributesConfig = new AttributesProducer(parent, docTypeName);
        this.docTypeName = docTypeName;
        this.storageRouteSpec = storageRouteSpec;
    }

    public final String getDocumentDBConfigId() {
        return this.attributesConfig.getConfigId();
    }

    @Override
    protected AbstractSearchCluster.IndexingMode getIndexingMode() {
        return AbstractSearchCluster.IndexingMode.STREAMING;
    }

    public final String getStorageRouteSpec() {
        return this.storageRouteSpec;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    @Override
    public int getRowBits() {
        return 0;
    }

    @Override
    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
        String searchName = this.sdConfig.getSearch().getName();
        docDb.name(searchName);
        Summaries prod = this.sdConfig.getSummaries();
        this.convertSummaryConfig(prod, null, docDb);
        RankProfilesConfig.Builder rpb = new RankProfilesConfig.Builder();
        this.sdConfig.getRankProfileList().getConfig(rpb);
        this.addRankProfilesConfig(docDb, new RankProfilesConfig(rpb));
        builder.documentdb(docDb);
    }

    @Override
    protected void deriveAllSchemas(List<AbstractSearchCluster.SchemaSpec> local, DeployState deployState) {
        if (local.size() == 1) {
            this.deriveSingleSearchDefinition(local.get(0).getSchema(), deployState);
        } else if (local.size() > 1) {
            throw new IllegalArgumentException("Only a single schema is supported, got " + local.size());
        }
    }

    private void deriveSingleSearchDefinition(Schema localSchema, DeployState deployState) {
        if (!localSchema.getName().equals(this.docTypeName)) {
            throw new IllegalArgumentException("Document type name '" + this.docTypeName + "' must be the same as the schema name '" + localSchema.getName() + "'");
        }
        this.sdConfig = new DerivedConfiguration(localSchema, deployState.getDeployLogger(), deployState.getProperties(), deployState.rankProfileRegistry(), deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels(), deployState.getExecutor());
    }

    @Override
    public DerivedConfiguration getSdConfig() {
        return this.sdConfig;
    }

    @Override
    public void defaultDocumentsConfig() {
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getConfig(builder);
        }
    }

    public void getConfig(VsmsummaryConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getVsmSummary() != null) {
            this.getSdConfig().getVsmSummary().getConfig(builder);
        }
    }

    public void getConfig(VsmfieldsConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getVsmFields() != null) {
            this.getSdConfig().getVsmFields().getConfig(builder);
        }
    }

    public void getConfig(SummarymapConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getSummaryMap() != null) {
            this.getSdConfig().getSummaryMap().getConfig(builder);
        }
    }

    public void getConfig(SummaryConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getSummaries() != null) {
            this.getSdConfig().getSummaries().getConfig(builder);
        }
    }

    private class AttributesProducer
    extends AbstractConfigProducer<AttributesProducer>
    implements AttributesConfig.Producer {
        AttributesProducer(AbstractConfigProducer<?> parent, String docType) {
            super(parent, docType);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            if (StreamingSearchCluster.this.getSdConfig() != null) {
                StreamingSearchCluster.this.getSdConfig().getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
            }
        }
    }
}

