/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import java.util.List;

class SearchHandler
extends ProcessingHandler<SearchChains> {
    static final String HANDLER_CLASS = com.yahoo.search.handler.SearchHandler.class.getName();
    static final BindingPattern DEFAULT_BINDING = SystemBindingPattern.fromHttpPath("/search/*");

    SearchHandler(ApplicationContainerCluster cluster, List<BindingPattern> bindings, ContainerThreadpool.UserOptions threadpoolOptions) {
        super(cluster.getSearchChains(), HANDLER_CLASS);
        bindings.forEach(xva$0 -> this.addServerBindings((BindingPattern)xva$0));
        Threadpool threadpool = new Threadpool(cluster, threadpoolOptions);
        this.inject(threadpool);
        this.addComponent(threadpool);
    }

    private static class Threadpool
    extends ContainerThreadpool {
        private final ApplicationContainerCluster cluster;

        Threadpool(ApplicationContainerCluster cluster, ContainerThreadpool.UserOptions options) {
            super("search-handler", options);
            this.cluster = cluster;
        }

        @Override
        public void getConfig(ContainerThreadpoolConfig.Builder builder) {
            super.getConfig(builder);
            builder.maxThreadExecutionTimeSeconds(190);
            builder.keepAliveTime(5.0);
            if (this.hasUserOptions()) {
                return;
            }
            builder.maxThreads(-2).minThreads(-2).queueSize(-40);
        }
    }
}

