/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.container.logging.JSONAccessLog;
import com.yahoo.container.logging.VespaAccessLog;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.Objects;

public final class AccessLogComponent
extends SimpleComponent
implements AccessLogConfig.Producer {
    private final String fileNamePattern;
    private final String rotationInterval;
    private final Boolean compression;
    private final boolean isHostedVespa;
    private final String symlinkName;
    private final CompressionType compressionType;
    private final int queueSize;
    private final Integer bufferSize;

    public AccessLogComponent(ContainerCluster<?> cluster, AccessLogType logType, CompressionType compressionType, String clusterName, boolean isHostedVespa) {
        this(logType, compressionType, String.format("logs/vespa/qrs/%s.%s.%s", AccessLogComponent.capitalize(logType.name()), clusterName, "%Y%m%d%H%M%S"), null, null, isHostedVespa, AccessLogComponent.capitalize(logType.name()) + "." + clusterName, -1, cluster instanceof ApplicationContainerCluster ? Integer.valueOf(0x400000) : null);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public AccessLogComponent(AccessLogType logType, CompressionType compressionType, String fileNamePattern, String rotationInterval, Boolean compressOnRotation, boolean isHostedVespa, String symlinkName, Integer queueSize, Integer bufferSize) {
        super(new ComponentModel(AccessLogComponent.accessLogClass(logType), null, "container-core", null));
        this.fileNamePattern = Objects.requireNonNull(fileNamePattern, "File name pattern required when configuring access log");
        this.rotationInterval = rotationInterval;
        this.compression = compressOnRotation;
        this.isHostedVespa = isHostedVespa;
        this.symlinkName = symlinkName;
        this.compressionType = compressionType;
        this.queueSize = queueSize == null ? 256 : queueSize;
        this.bufferSize = bufferSize;
    }

    private static String accessLogClass(AccessLogType logType) {
        switch (logType) {
            case queryAccessLog: {
                return VespaAccessLog.class.getName();
            }
            case jsonAccessLog: {
                return JSONAccessLog.class.getName();
            }
        }
        throw new AssertionError();
    }

    public void getConfig(AccessLogConfig.Builder builder) {
        builder.fileHandler(this.fileHandlerConfig());
    }

    private AccessLogConfig.FileHandler.Builder fileHandlerConfig() {
        AccessLogConfig.FileHandler.Builder builder = new AccessLogConfig.FileHandler.Builder();
        if (this.fileNamePattern != null) {
            builder.pattern(this.fileNamePattern);
        }
        if (this.rotationInterval != null) {
            builder.rotation(this.rotationInterval);
        }
        if (this.symlinkName != null) {
            builder.symlink(this.symlinkName);
        }
        if (this.compression != null) {
            builder.compressOnRotation(this.compression.booleanValue());
        } else if (this.isHostedVespa) {
            builder.compressOnRotation(true);
        }
        builder.queueSize(this.queueSize);
        if (this.bufferSize != null) {
            builder.bufferSize(this.bufferSize.intValue());
        }
        switch (this.compressionType) {
            case GZIP: {
                builder.compressionFormat(AccessLogConfig.FileHandler.CompressionFormat.GZIP);
                break;
            }
            case ZSTD: {
                builder.compressionFormat(AccessLogConfig.FileHandler.CompressionFormat.ZSTD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression type: " + this.compressionType);
            }
        }
        return builder;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public static enum CompressionType {
        GZIP,
        ZSTD;

    }

    public static enum AccessLogType {
        queryAccessLog,
        yApacheAccessLog,
        jsonAccessLog;

    }
}

