/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.version.VersionRange;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.path.Path;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractBundleValidator
extends Validator {
    private static final Pattern POM_FILE_LOCATION = Pattern.compile("META-INF/maven/.+?/.+?/pom.xml");

    protected abstract void validateManifest(DeployState var1, JarFile var2, Manifest var3);

    protected abstract void validatePomXml(DeployState var1, JarFile var2, Document var3);

    @Override
    public final void validate(VespaModel model, DeployState state) {
        ApplicationPackage app = state.getApplicationPackage();
        for (ComponentInfo info : app.getComponentsInfo(state.getVespaVersion())) {
            Path path = Path.fromString((String)info.getPathRelativeToAppDir());
            try {
                state.getDeployLogger().log(Level.FINE, String.format("Validating bundle at '%s'", path));
                JarFile jarFile = new JarFile(app.getFileReference(path));
                this.validateJarFile(state, jarFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to validate JAR file '" + path.last() + "'", e);
            }
        }
    }

    final void validateJarFile(DeployState state, JarFile jar) throws IOException {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("Non-existing or invalid manifest in " + this.filename(jar));
        }
        this.validateManifest(state, jar, manifest);
        this.getPomXmlContent(state.getDeployLogger(), jar).ifPresent(pom -> this.validatePomXml(state, jar, (Document)pom));
    }

    protected final String filename(JarFile jarFile) {
        return Paths.get(jarFile.getName(), new String[0]).getFileName().toString();
    }

    protected final void forEachPomXmlElement(Document pom, String xpath, Consumer<Element> consumer) throws XPathExpressionException {
        NodeList dependencies = (NodeList)XPathFactory.newDefaultInstance().newXPath().compile("/project/" + xpath).evaluate(pom, XPathConstants.NODESET);
        for (int i = 0; i < dependencies.getLength(); ++i) {
            Element element = (Element)dependencies.item(i);
            consumer.accept(element);
        }
    }

    protected final void forEachImportPackage(Manifest mf, BiConsumer<String, VersionRange> consumer) {
        Parameters importPackage = Domain.domain((Manifest)mf).getImportPackage();
        importPackage.forEach((packageName, attrs) -> {
            VersionRange versionRange = attrs.getVersion() != null ? VersionRange.parseOSGiVersionRange((String)attrs.getVersion()) : null;
            consumer.accept((String)packageName, versionRange);
        });
    }

    protected final void log(DeployState state, Level level, String fmt, Object ... args) {
        state.getDeployLogger().logApplicationPackage(level, String.format(fmt, args));
    }

    private Optional<Document> getPomXmlContent(DeployLogger deployLogger, JarFile jar) {
        return jar.stream().filter(f -> POM_FILE_LOCATION.matcher(f.getName()).matches()).findFirst().map(f -> {
            try {
                String text = new String(jar.getInputStream((ZipEntry)f).readAllBytes());
                return DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(new InputSource(new StringReader(text)));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                deployLogger.log(Level.INFO, String.format("Unable to parse pom.xml from %s", this.filename(jar)));
                return null;
            }
            catch (IOException e) {
                deployLogger.log(Level.INFO, String.format("Unable to read '%s' from '%s'", f.getName(), jar.getName()));
                return null;
            }
        });
    }
}

