/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.document.HnswIndexParams;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.parser.ParsedBlock;
import java.util.ArrayList;
import java.util.List;

class ParsedIndex
extends ParsedBlock {
    private boolean enableBm25 = false;
    private boolean isPrefix = false;
    private HnswIndexParams hnswParams;
    private final List<String> aliases = new ArrayList<String>();
    private Stemming stemming = null;
    private Integer arity;
    private Long lowerBound;
    private Long upperBound;
    private Double densePLT;

    ParsedIndex(String name) {
        super(name, "index");
    }

    boolean getEnableBm25() {
        return this.enableBm25;
    }

    boolean getPrefix() {
        return this.isPrefix;
    }

    HnswIndexParams getHnswIndexParams() {
        return this.hnswParams;
    }

    List<String> getAliases() {
        return List.copyOf(this.aliases);
    }

    boolean hasStemming() {
        return this.stemming != null;
    }

    Stemming getStemming() {
        return this.stemming;
    }

    Integer getArity() {
        return this.arity;
    }

    Long getLowerBound() {
        return this.lowerBound;
    }

    Long getUpperBound() {
        return this.upperBound;
    }

    Double getDensePostingListThreshold() {
        return this.densePLT;
    }

    void addAlias(String alias) {
        this.aliases.add(alias);
    }

    void setArity(int arity) {
        this.arity = arity;
    }

    void setDensePostingListThreshold(double threshold) {
        this.densePLT = threshold;
    }

    void setEnableBm25(boolean value) {
        this.enableBm25 = value;
    }

    void setHnswIndexParams(HnswIndexParams params) {
        this.hnswParams = params;
    }

    void setLowerBound(long value) {
        this.lowerBound = value;
    }

    void setPrefix(boolean value) {
        this.isPrefix = value;
    }

    void setStemming(Stemming stemming) {
        this.stemming = stemming;
    }

    void setUpperBound(long value) {
        this.upperBound = value;
    }
}

