/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.searchdefinition.parser.IntermediateCollection;
import com.yahoo.searchdefinition.parser.ParsedAnnotation;
import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedField;
import com.yahoo.searchdefinition.parser.ParsedFieldSet;
import com.yahoo.searchdefinition.parser.ParsedSchema;
import com.yahoo.searchdefinition.parser.ParsedStruct;
import com.yahoo.searchdefinition.parser.ParsedType;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConvertSchemaCollection {
    private final IntermediateCollection input;
    private final List<ParsedSchema> orderedInput = new ArrayList<ParsedSchema>();
    private final DocumentTypeManager docMan;
    Map<String, DocumentType> documentsInProgress = new HashMap<String, DocumentType>();
    Map<String, StructDataType> structsInProgress = new HashMap<String, StructDataType>();
    Map<String, AnnotationType> annotationsInProgress = new HashMap<String, AnnotationType>();

    public ConvertSchemaCollection(IntermediateCollection input, DocumentTypeManager documentTypeManager) {
        this.input = input;
        this.docMan = documentTypeManager;
        this.order();
        this.pushTypesToDocuments();
    }

    public void convertTypes() {
        this.convertDataTypes();
        this.registerDataTypes();
    }

    void order() {
        Map<String, ParsedSchema> map = this.input.getParsedSchemas();
        for (ParsedSchema schema : map.values()) {
            this.findOrdering(schema);
        }
    }

    void findOrdering(ParsedSchema schema) {
        if (this.orderedInput.contains(schema)) {
            return;
        }
        for (ParsedSchema parent : schema.getAllResolvedInherits()) {
            this.findOrdering(parent);
        }
        this.orderedInput.add(schema);
    }

    void pushTypesToDocuments() {
        for (ParsedSchema schema : this.orderedInput) {
            for (ParsedStruct struct : schema.getStructs()) {
                schema.getDocument().addStruct(struct);
            }
            for (ParsedAnnotation annotation : schema.getAnnotations()) {
                schema.getDocument().addAnnotation(annotation);
            }
        }
    }

    StructDataType findStructInProgress(String name, ParsedDocument context) {
        ParsedStruct resolved = this.findStructFrom(context, name);
        if (resolved == null) {
            throw new IllegalArgumentException("no struct named " + name + " in context " + context);
        }
        String structId = resolved.getOwner() + "->" + resolved.name();
        StructDataType struct = this.structsInProgress.get(structId);
        assert (struct != null);
        return struct;
    }

    AnnotationType findAnnotationInProgress(String name, ParsedDocument context) {
        ParsedAnnotation resolved = this.findAnnotationFrom(context, name);
        String annotationId = resolved.getOwner() + "->" + resolved.name();
        AnnotationType annotation = this.annotationsInProgress.get(annotationId);
        if (annotation == null) {
            throw new IllegalArgumentException("no annotation named " + name + " in context " + context);
        }
        return annotation;
    }

    ParsedStruct findStructFrom(ParsedDocument doc, String name) {
        ParsedStruct found = doc.getStruct(name);
        if (found != null) {
            return found;
        }
        for (ParsedDocument parent : doc.getResolvedInherits()) {
            ParsedStruct fromParent = this.findStructFrom(parent, name);
            if (fromParent == null || fromParent == found) continue;
            if (found == null) {
                found = fromParent;
                continue;
            }
            throw new IllegalArgumentException("conflicting values for struct " + name + " in " + doc);
        }
        return found;
    }

    ParsedAnnotation findAnnotationFrom(ParsedDocument doc, String name) {
        ParsedAnnotation found = doc.getAnnotation(name);
        if (found != null) {
            return found;
        }
        for (ParsedDocument parent : doc.getResolvedInherits()) {
            ParsedAnnotation fromParent = this.findAnnotationFrom(parent, name);
            if (fromParent == null || fromParent == found) continue;
            if (found == null) {
                found = fromParent;
                continue;
            }
            throw new IllegalArgumentException("conflicting values for annotation " + name + " in " + doc);
        }
        return found;
    }

    private DataType createArray(ParsedType pType, ParsedDocument context) {
        DataType nested = this.resolveType(pType.nestedType(), context);
        return DataType.getArray((DataType)nested);
    }

    private DataType createWset(ParsedType pType, ParsedDocument context) {
        DataType nested = this.resolveType(pType.nestedType(), context);
        boolean cine = pType.getCreateIfNonExistent();
        boolean riz = pType.getRemoveIfZero();
        return new WeightedSetDataType(nested, cine, riz);
    }

    private DataType createMap(ParsedType pType, ParsedDocument context) {
        DataType kt = this.resolveType(pType.mapKeyType(), context);
        DataType vt = this.resolveType(pType.mapValueType(), context);
        return DataType.getMap((DataType)kt, (DataType)vt);
    }

    private DocumentType findDocInProgress(String name) {
        DocumentType dt = this.documentsInProgress.get(name);
        if (dt == null) {
            throw new IllegalArgumentException("missing document type for: " + name);
        }
        return dt;
    }

    private DataType createAnnRef(ParsedType pType, ParsedDocument context) {
        AnnotationType annotation = this.findAnnotationInProgress(pType.getNameOfReferencedAnnotation(), context);
        return new AnnotationReferenceDataType(annotation);
    }

    private DataType createDocRef(ParsedType pType) {
        ParsedType ref = pType.getReferencedDocumentType();
        assert (ref.getVariant() == ParsedType.Variant.DOCUMENT);
        return ReferenceDataType.createWithInferredId((DocumentType)this.findDocInProgress(ref.name()));
    }

    DataType resolveType(ParsedType pType, ParsedDocument context) {
        switch (pType.getVariant()) {
            case NONE: {
                return DataType.NONE;
            }
            case BUILTIN: {
                return this.docMan.getDataType(pType.name());
            }
            case POSITION: {
                return PositionDataType.INSTANCE;
            }
            case ARRAY: {
                return this.createArray(pType, context);
            }
            case WSET: {
                return this.createWset(pType, context);
            }
            case MAP: {
                return this.createMap(pType, context);
            }
            case TENSOR: {
                return DataType.getTensor((TensorType)pType.getTensorType());
            }
            case DOC_REFERENCE: {
                return this.createDocRef(pType);
            }
            case ANN_REFERENCE: {
                return this.createAnnRef(pType, context);
            }
            case DOCUMENT: {
                return this.findDocInProgress(pType.name());
            }
            case STRUCT: {
                return this.findStructInProgress(pType.name(), context);
            }
        }
        if (this.documentsInProgress.containsKey(pType.name())) {
            pType.setVariant(ParsedType.Variant.DOCUMENT);
            return this.findDocInProgress(pType.name());
        }
        StructDataType struct = this.findStructInProgress(pType.name(), context);
        pType.setVariant(ParsedType.Variant.STRUCT);
        return struct;
    }

    void convertDataTypes() {
        Optional<ParsedStruct> withStruct;
        AnnotationType at;
        String annId;
        ParsedDocument doc;
        for (ParsedSchema schema : this.orderedInput) {
            String name = schema.getDocument().name();
            this.documentsInProgress.put(name, new DocumentType(name));
        }
        for (ParsedSchema schema : this.orderedInput) {
            doc = schema.getDocument();
            for (ParsedStruct struct : doc.getStructs()) {
                StructDataType dt = new StructDataType(struct.name());
                String structId = doc.name() + "->" + struct.name();
                this.structsInProgress.put(structId, dt);
            }
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                annId = doc.name() + "->" + annotation.name();
                at = new AnnotationType(annotation.name());
                this.annotationsInProgress.put(annId, at);
                withStruct = annotation.getStruct();
                if (!withStruct.isPresent()) continue;
                String sn = ((ParsedStruct)withStruct.get()).name();
                StructDataType dt = new StructDataType(sn);
                String structId = doc.name() + "->" + sn;
                this.structsInProgress.put(structId, dt);
            }
        }
        for (ParsedSchema schema : this.orderedInput) {
            String name;
            Field f;
            DataType t;
            doc = schema.getDocument();
            for (ParsedStruct struct : doc.getStructs()) {
                String structId = doc.name() + "->" + struct.name();
                StructDataType toFill = this.structsInProgress.get(structId);
                for (String inherit : struct.getInherited()) {
                    StructDataType parent = this.findStructInProgress(inherit, doc);
                    toFill.inherit(parent);
                }
                for (ParsedField field : struct.getFields()) {
                    t = this.resolveType(field.getType(), doc);
                    f = new Field(field.name(), t);
                    toFill.addField(f);
                }
            }
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                annId = doc.name() + "->" + annotation.name();
                at = this.annotationsInProgress.get(annId);
                withStruct = annotation.getStruct();
                if (withStruct.isPresent()) {
                    ParsedStruct struct = (ParsedStruct)withStruct.get();
                    String structId = doc.name() + "->" + struct.name();
                    StructDataType toFill = this.structsInProgress.get(structId);
                    for (ParsedField field : struct.getFields()) {
                        DataType t2 = this.resolveType(field.getType(), doc);
                        Field f2 = new Field(field.name(), t2);
                        toFill.addField(f2);
                    }
                    at.setDataType((DataType)toFill);
                }
                for (String inherit : annotation.getInherited()) {
                    AnnotationType parent = this.findAnnotationInProgress(inherit, doc);
                    at.inherit(parent);
                }
            }
            DocumentType docToFill = this.documentsInProgress.get(doc.name());
            HashMap<String, List<Object>> fieldSets = new HashMap<String, List<Object>>();
            ArrayList<String> inDocFields = new ArrayList<String>();
            for (ParsedField docField : doc.getFields()) {
                name = docField.name();
                t = this.resolveType(docField.getType(), doc);
                f = new Field(name, t);
                docToFill.addField(f);
                inDocFields.add(name);
            }
            fieldSets.put("[document]", inDocFields);
            for (ParsedField extraField : schema.getFields()) {
                name = extraField.name();
                t = this.resolveType(extraField.getType(), doc);
                f = new Field(name, t);
                docToFill.addField(f);
            }
            for (ParsedFieldSet fieldset : schema.getFieldSets()) {
                fieldSets.put(fieldset.name(), fieldset.getFieldNames());
            }
            docToFill.addFieldSets(fieldSets);
            for (String inherit : doc.getInherited()) {
                docToFill.inherit(this.findDocInProgress(inherit));
            }
        }
    }

    void registerDataTypes() {
        for (DataType dataType : this.structsInProgress.values()) {
            this.docMan.register(dataType);
        }
        for (DocumentType documentType : this.documentsInProgress.values()) {
            this.docMan.register((DataType)documentType);
        }
        for (AnnotationType annotationType : this.annotationsInProgress.values()) {
            this.docMan.getAnnotationTypeRegistry().register(annotationType);
        }
    }
}

