/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing.multifieldresolver;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.multifieldresolver.MultiFieldResolver;
import java.util.List;
import java.util.logging.Level;

public class StemmingResolver
extends MultiFieldResolver {
    public StemmingResolver(String indexName, List<SDField> fields, Schema schema, DeployLogger logger) {
        super(indexName, fields, schema, logger);
    }

    @Override
    public void resolve() {
        this.checkStemmingForIndexFields(this.indexName, this.fields);
    }

    private void checkStemmingForIndexFields(String indexName, List<SDField> fields) {
        Stemming stemming = null;
        SDField stemmingField = null;
        for (SDField field : fields) {
            if (stemming == null && stemmingField == null) {
                stemming = field.getStemming(this.schema);
                stemmingField = field;
                continue;
            }
            if (stemming == field.getStemming(this.schema)) continue;
            this.deployLogger.logApplicationPackage(Level.WARNING, "Field '" + field.getName() + "' has " + field.getStemming(this.schema) + ", whereas field '" + stemmingField.getName() + "' has " + stemming + ". All fields indexing to the index '" + indexName + "' must have the same stemming. This should be corrected as it will make indexing fail in a few cases.");
        }
    }
}

