/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class Processor {
    protected final Schema schema;
    protected final DeployLogger deployLogger;
    protected final RankProfileRegistry rankProfileRegistry;
    protected final QueryProfiles queryProfiles;

    public Processor(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        this.schema = schema;
        this.deployLogger = deployLogger;
        this.rankProfileRegistry = rankProfileRegistry;
        this.queryProfiles = queryProfiles;
    }

    public abstract void process(boolean var1, boolean var2);

    public void process(boolean validate, boolean documentsOnly, ModelContext.Properties properties) {
        this.process(validate, documentsOnly);
    }

    protected SDField addField(Schema schema, SDField field, String suffix, String indexing, String queryCommand) {
        SDField implementationField = schema.getConcreteField(field.getName() + "_" + suffix);
        if (implementationField != null) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Implementation field " + implementationField + " added twice");
        } else {
            implementationField = new SDField(schema.getDocument(), field.getName() + "_" + suffix, (DataType)DataType.STRING);
        }
        implementationField.setRankType(RankType.EMPTY);
        implementationField.setStemming(Stemming.NONE);
        implementationField.getNormalizing().inferCodepoint();
        implementationField.parseIndexingScript(indexing);
        String indexName = field.getName();
        String implementationIndexName = indexName + "_" + suffix;
        Index implementationIndex = new Index(implementationIndexName);
        schema.addIndex(implementationIndex);
        if (queryCommand != null) {
            field.addQueryCommand(queryCommand);
        }
        schema.addExtraField(implementationField);
        schema.fieldSets().addBuiltInFieldSetItem("[internal]", implementationField.getName());
        return implementationField;
    }

    protected Iterator<RankProfile.RankSetting> matchingRankSettingsIterator(Schema schema, RankProfile.RankSetting.Type type) {
        ArrayList<RankProfile.RankSetting> someRankSettings = new ArrayList<RankProfile.RankSetting>();
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(schema)) {
            Iterator<RankProfile.RankSetting> j = profile.declaredRankSettingIterator();
            while (j.hasNext()) {
                RankProfile.RankSetting setting = j.next();
                if (!setting.getType().equals((Object)type)) continue;
                someRankSettings.add(setting);
            }
        }
        return someRankSettings.iterator();
    }

    protected String formatError(String schemaName, String fieldName, String msg) {
        return "For schema '" + schemaName + "', field '" + fieldName + "': " + msg;
    }

    protected RuntimeException newProcessException(String schemaName, String fieldName, String msg) {
        return new IllegalArgumentException(this.formatError(schemaName, fieldName, msg));
    }

    protected RuntimeException newProcessException(Schema schema, Field field, String msg) {
        return this.newProcessException(schema.getName(), field.getName(), msg);
    }

    public void fail(Schema schema, Field field, String msg) {
        throw this.newProcessException(schema, field, msg);
    }

    protected void warn(String schemaName, String fieldName, String message) {
        String fullMsg = this.formatError(schemaName, fieldName, message);
        this.deployLogger.logApplicationPackage(Level.WARNING, fullMsg);
    }

    protected void warn(Schema schema, Field field, String message) {
        this.warn(schema.getName(), field.getName(), message);
    }

    protected void info(String schemaName, String fieldName, String message) {
        String fullMsg = this.formatError(schemaName, fieldName, message);
        this.deployLogger.logApplicationPackage(Level.INFO, fullMsg);
    }

    protected void info(Schema schema, Field field, String message) {
        this.info(schema.getName(), field.getName(), message);
    }
}

