/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedStruct
extends ParsedBlock {
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, ParsedField> fields = new HashMap<String, ParsedField>();
    private String ownedBy = null;

    public ParsedStruct(String name) {
        super(name, "struct");
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.fields.values());
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    String getOwner() {
        return this.ownedBy;
    }

    void addField(ParsedField field) {
        String fieldName = field.name();
        this.verifyThat(!this.fields.containsKey(fieldName), "already has field", fieldName);
        this.fields.put(fieldName, field);
    }

    void inherit(String other) {
        this.verifyThat(!this.name().equals(other), "cannot inherit from itself", new Object[0]);
        this.inherited.add(other);
    }

    void tagOwner(String document) {
        this.verifyThat(this.ownedBy == null, "already owned by document " + this.ownedBy, new Object[0]);
        this.ownedBy = document;
    }
}

