/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedBlock;
import java.util.Optional;

class ParsedSorting
extends ParsedBlock {
    private boolean ascending = true;
    private Function sortFunction = null;
    private Strength sortStrength = null;
    private String sortLocale = null;

    ParsedSorting(String blockName, String blockType) {
        super(blockName, blockType);
    }

    boolean getAscending() {
        return this.ascending;
    }

    boolean getDescending() {
        return !this.ascending;
    }

    Optional<Function> getFunction() {
        return Optional.ofNullable(this.sortFunction);
    }

    Optional<Strength> getStrength() {
        return Optional.ofNullable(this.sortStrength);
    }

    Optional<String> getLocale() {
        return Optional.ofNullable(this.sortLocale);
    }

    void setAscending() {
        this.ascending = true;
    }

    void setDescending() {
        this.ascending = false;
    }

    void setLocale(String value) {
        this.verifyThat(this.sortLocale == null, "sorting already has locale", this.sortLocale);
        this.sortLocale = value;
    }

    void setFunction(Function value) {
        this.verifyThat(this.sortFunction == null, "sorting already has function", new Object[]{this.sortFunction});
        this.sortFunction = value;
    }

    void setStrength(Strength value) {
        this.verifyThat(this.sortStrength == null, "sorting already has strength", new Object[]{this.sortStrength});
        this.sortStrength = value;
    }

    static enum Strength {
        PRIMARY,
        SECONDARY,
        TERTIARY,
        QUATERNARY,
        IDENTICAL;

    }

    static enum Function {
        RAW,
        LOWERCASE,
        UCA;

    }
}

