/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.parser.ParsedAnnotation;
import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedDocumentSummary;
import com.yahoo.searchdefinition.parser.ParsedField;
import com.yahoo.searchdefinition.parser.ParsedFieldSet;
import com.yahoo.searchdefinition.parser.ParsedIndex;
import com.yahoo.searchdefinition.parser.ParsedRankProfile;
import com.yahoo.searchdefinition.parser.ParsedStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedSchema
extends ParsedBlock {
    private boolean rawAsBase64 = false;
    private ParsedDocument myDocument = null;
    private Stemming defaultStemming = null;
    private final List<ImportedField> importedFields = new ArrayList<ImportedField>();
    private final List<OnnxModel> onnxModels = new ArrayList<OnnxModel>();
    private final List<RankingConstant> rankingConstants = new ArrayList<RankingConstant>();
    private final List<String> inherited = new ArrayList<String>();
    private final List<String> inheritedByDocument = new ArrayList<String>();
    private final Map<String, ParsedSchema> resolvedInherits = new HashMap<String, ParsedSchema>();
    private final Map<String, ParsedSchema> allResolvedInherits = new HashMap<String, ParsedSchema>();
    private final Map<String, ParsedAnnotation> extraAnnotations = new HashMap<String, ParsedAnnotation>();
    private final Map<String, ParsedDocumentSummary> docSums = new HashMap<String, ParsedDocumentSummary>();
    private final Map<String, ParsedField> extraFields = new HashMap<String, ParsedField>();
    private final Map<String, ParsedFieldSet> fieldSets = new HashMap<String, ParsedFieldSet>();
    private final Map<String, ParsedIndex> extraIndexes = new HashMap<String, ParsedIndex>();
    private final Map<String, ParsedRankProfile> rankProfiles = new HashMap<String, ParsedRankProfile>();
    private final Map<String, ParsedStruct> extraStructs = new HashMap<String, ParsedStruct>();

    public ParsedSchema(String name) {
        super(name, "schema");
    }

    boolean getRawAsBase64() {
        return this.rawAsBase64;
    }

    boolean hasDocument() {
        return this.myDocument != null;
    }

    ParsedDocument getDocument() {
        return this.myDocument;
    }

    boolean hasStemming() {
        return this.defaultStemming != null;
    }

    Stemming getStemming() {
        return this.defaultStemming;
    }

    List<ImportedField> getImportedFields() {
        return List.copyOf(this.importedFields);
    }

    List<OnnxModel> getOnnxModels() {
        return List.copyOf(this.onnxModels);
    }

    List<ParsedAnnotation> getAnnotations() {
        return List.copyOf(this.extraAnnotations.values());
    }

    List<ParsedDocumentSummary> getDocumentSummaries() {
        return List.copyOf(this.docSums.values());
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.extraFields.values());
    }

    List<ParsedFieldSet> getFieldSets() {
        return List.copyOf(this.fieldSets.values());
    }

    List<ParsedIndex> getIndexes() {
        return List.copyOf(this.extraIndexes.values());
    }

    List<ParsedStruct> getStructs() {
        return List.copyOf(this.extraStructs.values());
    }

    List<RankingConstant> getRankingConstants() {
        return List.copyOf(this.rankingConstants);
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    List<String> getInheritedByDocument() {
        return List.copyOf(this.inheritedByDocument);
    }

    Map<String, ParsedRankProfile> getRankProfiles() {
        return Map.copyOf(this.rankProfiles);
    }

    List<ParsedSchema> getResolvedInherits() {
        return List.copyOf(this.resolvedInherits.values());
    }

    List<ParsedSchema> getAllResolvedInherits() {
        return List.copyOf(this.allResolvedInherits.values());
    }

    void addAnnotation(ParsedAnnotation annotation) {
        String annName = annotation.name();
        this.verifyThat(!this.extraAnnotations.containsKey(annName), "already has annotation", annName);
        this.extraAnnotations.put(annName, annotation);
    }

    void addDocument(ParsedDocument document) {
        this.verifyThat(this.myDocument == null, "already has", this.myDocument, "so cannot add", document);
        this.verifyThat(this.name().equals(document.name()), "schema " + this.name() + "can only contain document named " + this.name() + ", was: " + document.name(), new Object[0]);
        this.myDocument = document;
    }

    void addDocumentSummary(ParsedDocumentSummary docsum) {
        String dsName = docsum.name();
        this.verifyThat(!this.docSums.containsKey(dsName), "already has document-summary", dsName);
        this.docSums.put(dsName, docsum);
    }

    void addField(ParsedField field) {
        String fieldName = field.name();
        this.verifyThat(!this.extraFields.containsKey(fieldName), "already has field", fieldName);
        this.extraFields.put(fieldName, field);
    }

    void addFieldSet(ParsedFieldSet fieldSet) {
        String fsName = fieldSet.name();
        this.verifyThat(!this.fieldSets.containsKey(fsName), "already has fieldset", fsName);
        this.fieldSets.put(fsName, fieldSet);
    }

    void addImportedField(String asFieldName, String refFieldName, String foregnFieldName) {
        this.importedFields.add(new ImportedField(asFieldName, refFieldName, foregnFieldName));
    }

    void addIndex(ParsedIndex index) {
        String idxName = index.name();
        this.verifyThat(!this.extraIndexes.containsKey(idxName), "already has index", idxName);
        this.extraIndexes.put(idxName, index);
    }

    void addOnnxModel(OnnxModel model) {
        this.onnxModels.add(model);
    }

    void addRankProfile(ParsedRankProfile profile) {
        String rpName = profile.name();
        this.verifyThat(!this.rankProfiles.containsKey(rpName), "already has rank-profile", rpName);
        this.rankProfiles.put(rpName, profile);
    }

    void addRankingConstant(RankingConstant constant) {
        this.rankingConstants.add(constant);
    }

    void addStruct(ParsedStruct struct) {
        String sName = struct.name();
        this.verifyThat(!this.extraStructs.containsKey(sName), "already has struct", sName);
        this.extraStructs.put(sName, struct);
    }

    void enableRawAsBase64(boolean value) {
        this.rawAsBase64 = value;
    }

    void inherit(String other) {
        this.inherited.add(other);
    }

    void inheritByDocument(String other) {
        this.inheritedByDocument.add(other);
    }

    void setStemming(Stemming value) {
        this.verifyThat(this.defaultStemming == null || this.defaultStemming == value, "already has stemming", new Object[]{this.defaultStemming, "cannot also set", value});
        this.defaultStemming = value;
    }

    void resolveInherit(String name, ParsedSchema parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.verifyThat(!this.resolvedInherits.containsKey(name), "double resolveInherit for", name);
        this.resolvedInherits.put(name, parsed);
        ParsedSchema old = this.allResolvedInherits.put(name, parsed);
        this.verifyThat(old == null || old == parsed, "conflicting resolveInherit for", name);
    }

    void resolveInheritByDocument(String name, ParsedSchema parsed) {
        this.verifyThat(this.inheritedByDocument.contains(name), "resolveInheritByDocument for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInheritByDocument name mismatch for", name);
        ParsedSchema old = this.allResolvedInherits.put(name, parsed);
        this.verifyThat(old == null || old == parsed, "conflicting resolveInherit for", name);
    }

    public static class ImportedField {
        public final String asFieldName;
        public final String refFieldName;
        public final String foreignFieldName;

        public ImportedField(String asField, String refField, String foreignField) {
            this.asFieldName = asField;
            this.refFieldName = refField;
            this.foreignFieldName = foreignField;
        }
    }
}

