/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedAnnotation;
import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedField;
import com.yahoo.searchdefinition.parser.ParsedStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParsedDocument
extends ParsedBlock {
    private final List<String> inherited = new ArrayList<String>();
    private final Map<String, ParsedDocument> resolvedInherits = new HashMap<String, ParsedDocument>();
    private final Map<String, ParsedField> docFields = new HashMap<String, ParsedField>();
    private final Map<String, ParsedStruct> docStructs = new HashMap<String, ParsedStruct>();
    private final Map<String, ParsedAnnotation> docAnnotations = new HashMap<String, ParsedAnnotation>();

    public ParsedDocument(String name) {
        super(name, "document");
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    List<ParsedAnnotation> getAnnotations() {
        return List.copyOf(this.docAnnotations.values());
    }

    List<ParsedDocument> getResolvedInherits() {
        return List.copyOf(this.resolvedInherits.values());
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.docFields.values());
    }

    List<ParsedStruct> getStructs() {
        return List.copyOf(this.docStructs.values());
    }

    ParsedStruct getStruct(String name) {
        return this.docStructs.get(name);
    }

    ParsedAnnotation getAnnotation(String name) {
        return this.docAnnotations.get(name);
    }

    void inherit(String other) {
        this.inherited.add(other);
    }

    void addField(ParsedField field) {
        String fieldName = field.name();
        this.verifyThat(!this.docFields.containsKey(fieldName), "already has field", fieldName);
        this.docFields.put(fieldName, field);
    }

    void addStruct(ParsedStruct struct) {
        String sName = struct.name();
        this.verifyThat(!this.docStructs.containsKey(sName), "already has struct", sName);
        this.docStructs.put(sName, struct);
        struct.tagOwner(this.name());
    }

    void addAnnotation(ParsedAnnotation annotation) {
        String annName = annotation.name();
        this.verifyThat(!this.docAnnotations.containsKey(annName), "already has annotation", annName);
        this.docAnnotations.put(annName, annotation);
        annotation.tagOwner(this.name());
    }

    public String toString() {
        return "document " + this.name();
    }

    void resolveInherit(String name, ParsedDocument parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.verifyThat(!this.resolvedInherits.containsKey(name), "double resolveInherit for", name);
        this.resolvedInherits.put(name, parsed);
    }
}

