/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InheritanceResolver {
    private final Map<String, ParsedSchema> parsedSchemas;
    private final Map<String, ParsedDocument> parsedDocs = new HashMap<String, ParsedDocument>();

    public InheritanceResolver(Map<String, ParsedSchema> parsedSchemas) {
        this.parsedSchemas = parsedSchemas;
    }

    private void inheritanceCycleCheck(ParsedSchema schema, List<String> seen) {
        String name = schema.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance cycle for schemas: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedSchema parent : schema.getAllResolvedInherits()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }

    private void resolveSchemaInheritance() {
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            for (String inherit : schema.getInherited()) {
                ParsedSchema parent = this.parsedSchemas.get(inherit);
                if (parent == null) {
                    throw new IllegalArgumentException("schema " + schema.name() + " inherits from unavailable schema " + inherit);
                }
                schema.resolveInherit(inherit, parent);
            }
        }
    }

    private void checkSchemaCycles() {
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            this.inheritanceCycleCheck(schema, seen);
        }
    }

    private void resolveDocumentInheritance() {
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            ParsedDocument old;
            ParsedDocument doc;
            if (!schema.hasDocument()) {
                doc = new ParsedDocument(schema.name());
                for (String string : schema.getInherited()) {
                    doc.inherit(string);
                }
                schema.addDocument(doc);
            }
            if ((old = this.parsedDocs.put((doc = schema.getDocument()).name(), doc)) != null) {
                throw new IllegalArgumentException("duplicate document declaration for " + doc.name());
            }
            for (String docInherit : doc.getInherited()) {
                schema.inheritByDocument(docInherit);
            }
        }
        for (ParsedDocument doc : this.parsedDocs.values()) {
            for (String inherit : doc.getInherited()) {
                ParsedDocument parsedDocument = this.parsedDocs.get(inherit);
                if (parsedDocument == null) {
                    throw new IllegalArgumentException("document " + doc.name() + " inherits from unavailable document " + inherit);
                }
                doc.resolveInherit(inherit, parsedDocument);
            }
        }
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            for (String inherit : schema.getInheritedByDocument()) {
                ParsedSchema parsedSchema = this.parsedSchemas.get(inherit);
                assert (parsedSchema.hasDocument());
                assert (parsedSchema.getDocument().name().equals(inherit));
                schema.resolveInheritByDocument(inherit, parsedSchema);
            }
        }
    }

    private void inheritanceCycleCheck(ParsedDocument document, List<String> seen) {
        String name = document.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance cycle for documents: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedDocument parent : document.getResolvedInherits()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }

    private void checkDocumentCycles() {
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedDocument doc : this.parsedDocs.values()) {
            this.inheritanceCycleCheck(doc, seen);
        }
    }

    public void resolveInheritance() {
        this.resolveSchemaInheritance();
        this.resolveDocumentInheritance();
        this.checkDocumentCycles();
        this.checkSchemaCycles();
    }
}

