/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.DistributableResource;
import com.yahoo.tensor.TensorType;

public class RankingConstant
extends DistributableResource {
    private TensorType tensorType = null;

    public RankingConstant(String name) {
        super(name);
    }

    public RankingConstant(String name, TensorType type, String fileName) {
        this(name, type, fileName, DistributableResource.PathType.FILE);
    }

    public RankingConstant(String name, TensorType type, String fileName, DistributableResource.PathType pathType) {
        super(name, fileName, pathType);
        this.tensorType = type;
        this.validate();
    }

    public void setType(TensorType type) {
        this.tensorType = type;
    }

    public TensorType getTensorType() {
        return this.tensorType;
    }

    public String getType() {
        return this.tensorType.toString();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.tensorType == null) {
            throw new IllegalArgumentException("Ranking constant '" + this.getName() + "' must have a type.");
        }
        if (this.tensorType.dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
            throw new IllegalArgumentException("Illegal type in field " + this.getName() + " type " + this.tensorType + ": Dense tensor dimensions must have a size");
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString()).append("' of type '").append(this.tensorType).append("'");
        return b.toString();
    }
}

