/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.searchdefinition.DocumentGraphValidator;
import com.yahoo.searchdefinition.DocumentModelBuilder;
import com.yahoo.searchdefinition.DocumentReferenceResolver;
import com.yahoo.searchdefinition.FieldOperationApplier;
import com.yahoo.searchdefinition.FieldOperationApplierForSearch;
import com.yahoo.searchdefinition.FieldOperationApplierForStructs;
import com.yahoo.searchdefinition.ImportedFieldsEnumerator;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SDDocumentTypeOrderer;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.TemporarySDTypeResolver;
import com.yahoo.searchdefinition.derived.SearchOrderer;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.processing.Processing;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Application {
    private final ApplicationPackage applicationPackage;
    private final Map<String, Schema> schemas;
    private final DocumentModel documentModel;
    private final RankProfileRegistry rankProfileRegistry;

    public Application(ApplicationPackage applicationPackage, List<Schema> schemas, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, ModelContext.Properties properties, boolean documentsOnly, boolean validate, Set<Class<? extends Processor>> processorsToSkip, DeployLogger logger) {
        this.applicationPackage = applicationPackage;
        LinkedHashMap<String, Schema> schemaMap = new LinkedHashMap<String, Schema>();
        for (Schema schema2 : schemas) {
            if (schemaMap.containsKey(schema2.getName())) {
                throw new IllegalArgumentException("Duplicate schema '" + schema2.getName() + "' in " + this);
            }
            schemaMap.put(schema2.getName(), schema2);
        }
        this.schemas = Collections.unmodifiableMap(schemaMap);
        this.rankProfileRegistry = rankProfileRegistry;
        schemas.forEach(schema -> schema.setOwner(this));
        if (validate) {
            schemas.forEach(schema -> schema.validate(logger));
        }
        new TemporarySDTypeResolver(schemas, logger).process();
        ArrayList<SDDocumentType> sdocs = new ArrayList<SDDocumentType>();
        sdocs.add(SDDocumentType.VESPA_DOCUMENT);
        for (Schema schema3 : schemas) {
            if (!schema3.hasDocument()) continue;
            sdocs.add(schema3.getDocument());
        }
        SDDocumentTypeOrderer sDDocumentTypeOrderer = new SDDocumentTypeOrderer(sdocs, logger);
        sDDocumentTypeOrderer.process();
        for (SDDocumentType sdoc : sDDocumentTypeOrderer.getOrdered()) {
            new FieldOperationApplierForStructs().process(sdoc);
            new FieldOperationApplier().process(sdoc);
        }
        DocumentReferenceResolver documentReferenceResolver = new DocumentReferenceResolver(schemas);
        sdocs.forEach(documentReferenceResolver::resolveReferences);
        sdocs.forEach(documentReferenceResolver::resolveInheritedReferences);
        ImportedFieldsEnumerator importedFieldsEnumerator = new ImportedFieldsEnumerator(schemas);
        sdocs.forEach(importedFieldsEnumerator::enumerateImportedFields);
        if (validate) {
            new DocumentGraphValidator().validateDocumentGraph(sdocs);
        }
        ArrayList<Schema> schemasSomewhatOrdered = new ArrayList<Schema>(schemas);
        for (Schema schema4 : new SearchOrderer().order(schemasSomewhatOrdered)) {
            new FieldOperationApplierForSearch().process(schema4);
            new Processing(properties).process(schema4, logger, rankProfileRegistry, queryProfiles, validate, documentsOnly, processorsToSkip);
        }
        this.documentModel = new DocumentModelBuilder().build(schemasSomewhatOrdered);
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Map<String, Schema> schemas() {
        return this.schemas;
    }

    public RankProfileRegistry rankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public DocumentModel documentModel() {
        return this.documentModel;
    }

    public String toString() {
        return "application " + this.applicationPackage.getApplicationId();
    }
}

