/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.expressiontransforms.OnnxModelTransformer;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.ml.OnnxModelInfo;
import java.util.Map;

public class OnnxModelConfigGenerator
extends Processor {
    public OnnxModelConfigGenerator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            if (profile.getFirstPhaseRanking() != null) {
                this.process(profile.getFirstPhaseRanking().getRoot());
            }
            if (profile.getSecondPhaseRanking() != null) {
                this.process(profile.getSecondPhaseRanking().getRoot());
            }
            for (Map.Entry<String, RankProfile.RankingExpressionFunction> function : profile.getFunctions().entrySet()) {
                this.process(function.getValue().function().getBody().getRoot());
            }
            for (ReferenceNode feature : profile.getSummaryFeatures()) {
                this.process(feature);
            }
        }
    }

    private void process(ExpressionNode node) {
        if (node instanceof ReferenceNode) {
            this.process((ReferenceNode)node);
        } else if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                this.process(child);
            }
        }
    }

    private void process(ReferenceNode feature) {
        if ((feature.getName().equals("onnxModel") || feature.getName().equals("onnx")) && feature.getArguments().size() > 0 && feature.getArguments().expressions().get(0) instanceof ConstantNode) {
            ConstantNode node = (ConstantNode)feature.getArguments().expressions().get(0);
            String path = OnnxModelTransformer.stripQuotes(node.toString());
            String modelConfigName = OnnxModelTransformer.asValidIdentifier(path);
            if (!OnnxModelInfo.modelExists(path, this.schema.applicationPackage()) && !OnnxModelInfo.modelExists(path = ApplicationPackage.MODELS_DIR.append(path).toString(), this.schema.applicationPackage())) {
                return;
            }
            OnnxModel onnxModel = this.schema.onnxModels().get(modelConfigName);
            if (onnxModel == null) {
                onnxModel = new OnnxModel(modelConfigName, path);
                this.schema.onnxModels().add(onnxModel);
            }
        }
    }
}

