/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.searchdefinition.FieldSets;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.searchdefinition.document.GeoPos;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class VsmFields
extends Derived
implements VsmfieldsConfig.Producer {
    private final Map<String, StreamingField> fields = new LinkedHashMap<String, StreamingField>();
    private final Map<String, StreamingDocumentType> doctypes = new LinkedHashMap<String, StreamingDocumentType>();

    public VsmFields(Schema schema) {
        this.addSearchdefinition(schema);
    }

    private void addSearchdefinition(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(SDDocumentType document, Schema schema) {
        super.derive(document, schema);
        StreamingDocumentType docType = this.getDocumentType(document.getName());
        if (docType == null) {
            docType = new StreamingDocumentType(document.getName(), schema.fieldSets());
            this.doctypes.put(document.getName(), docType);
        }
        for (Field o : document.fieldSet()) {
            this.derive(docType, (SDField)o);
        }
    }

    protected void derive(StreamingDocumentType document, SDField field) {
        if (field.usesStructOrMap()) {
            if (GeoPos.isAnyPos(field)) {
                StreamingField streamingField = new StreamingField(field);
                this.addField(streamingField.getName(), streamingField);
                this.addFieldToIndices(document, field.getName(), streamingField);
            }
            for (SDField structField : field.getStructFields()) {
                this.derive(document, structField);
            }
        } else {
            if (!(field.doesIndexing() || field.doesSummarying() || field.doesAttributing())) {
                return;
            }
            StreamingField streamingField = new StreamingField(field);
            this.addField(streamingField.getName(), streamingField);
            this.deriveIndices(document, field, streamingField);
        }
    }

    private void deriveIndices(StreamingDocumentType document, SDField field, StreamingField streamingField) {
        if (field.doesIndexing()) {
            this.addFieldToIndices(document, field.getName(), streamingField);
        } else if (field.doesAttributing()) {
            for (String indexName : field.getAttributes().keySet()) {
                this.addFieldToIndices(document, indexName, streamingField);
            }
        }
    }

    private void addFieldToIndices(StreamingDocumentType document, String indexName, StreamingField streamingField) {
        if (indexName.contains(".")) {
            this.addFieldToIndices(document, indexName.substring(0, indexName.lastIndexOf(".")), streamingField);
        }
        document.addIndexField(indexName, streamingField.getName());
    }

    private void addField(String name, StreamingField field) {
        this.fields.put(name, field);
    }

    public StreamingDocumentType getDocumentType(String name) {
        return this.doctypes.get(name);
    }

    @Override
    public String getDerivedName() {
        return "vsmfields";
    }

    public void getConfig(VsmfieldsConfig.Builder vsB) {
        for (StreamingField streamingField : this.fields.values()) {
            vsB.fieldspec(streamingField.getFieldSpecConfig());
        }
        for (StreamingDocumentType streamingDocType : this.doctypes.values()) {
            vsB.documenttype(streamingDocType.getDocTypeConfig());
        }
    }

    private static class StreamingDocumentType {
        private final String name;
        private final Map<String, FieldSet> fieldSets = new LinkedHashMap<String, FieldSet>();
        private final Map<String, FieldSet> userFieldSets;

        public StreamingDocumentType(String name, FieldSets fieldSets) {
            this.name = name;
            this.userFieldSets = fieldSets.userFieldSets();
        }

        public VsmfieldsConfig.Documenttype.Builder getDocTypeConfig() {
            VsmfieldsConfig.Documenttype.Builder dtB = new VsmfieldsConfig.Documenttype.Builder();
            dtB.name(this.name);
            LinkedHashMap<String, FieldSet> all = new LinkedHashMap<String, FieldSet>();
            all.putAll(this.fieldSets);
            all.putAll(this.userFieldSets);
            for (Map.Entry e : all.entrySet()) {
                VsmfieldsConfig.Documenttype.Index.Builder indB = new VsmfieldsConfig.Documenttype.Index.Builder();
                indB.name(((FieldSet)e.getValue()).getName());
                for (String field : ((FieldSet)e.getValue()).getFieldNames()) {
                    indB.field(new VsmfieldsConfig.Documenttype.Index.Field.Builder().name(field));
                }
                dtB.index(indB);
            }
            return dtB;
        }

        public String getName() {
            return this.name;
        }

        public void addIndexField(String indexName, String fieldName) {
            FieldSet fs = this.fieldSets.get(indexName);
            if (fs == null) {
                fs = new FieldSet(indexName);
                this.fieldSets.put(indexName, fs);
            }
            fs.addFieldName(fieldName);
        }
    }

    private static class StreamingField {
        private final String name;
        private final Matching matching;
        private final Type type;
        private final boolean isAttribute;

        public StreamingField(SDField field) {
            this(field.getName(), field.getDataType(), field.getMatching(), field.doesAttributing());
        }

        private StreamingField(String name, DataType sourceType, Matching matching, boolean isAttribute) {
            this.name = name;
            this.type = StreamingField.convertType(sourceType);
            this.matching = matching;
            this.isAttribute = isAttribute;
        }

        private static Type convertType(DataType fieldType) {
            FieldValue fval = fieldType.createFieldValue();
            if (fieldType.equals((Object)DataType.FLOAT16)) {
                return Type.FLOAT16;
            }
            if (fieldType.equals((Object)DataType.FLOAT)) {
                return Type.FLOAT;
            }
            if (fieldType.equals((Object)DataType.LONG)) {
                return Type.INT64;
            }
            if (fieldType.equals((Object)DataType.DOUBLE)) {
                return Type.DOUBLE;
            }
            if (fieldType.equals((Object)DataType.BOOL)) {
                return Type.BOOL;
            }
            if (fieldType.equals((Object)DataType.BYTE)) {
                return Type.INT8;
            }
            if (GeoPos.isAnyPos(fieldType)) {
                return Type.GEO_POSITION;
            }
            if (fieldType instanceof NumericDataType) {
                return Type.INT32;
            }
            if (fval instanceof StringFieldValue) {
                return Type.STRING;
            }
            if (fval instanceof BoolFieldValue) {
                return Type.BOOL;
            }
            if (fval instanceof Raw) {
                return Type.STRING;
            }
            if (fval instanceof PredicateFieldValue) {
                return Type.UNSEARCHABLESTRING;
            }
            if (fval instanceof TensorFieldValue) {
                return Type.UNSEARCHABLESTRING;
            }
            if (fieldType instanceof CollectionDataType) {
                return StreamingField.convertType(((CollectionDataType)fieldType).getNestedType());
            }
            if (fieldType instanceof ReferenceDataType) {
                return Type.UNSEARCHABLESTRING;
            }
            throw new IllegalArgumentException("Don't know which streaming field type to convert " + fieldType + " to");
        }

        public String getName() {
            return this.name;
        }

        public VsmfieldsConfig.Fieldspec.Builder getFieldSpecConfig() {
            VsmfieldsConfig.Fieldspec.Builder fB = new VsmfieldsConfig.Fieldspec.Builder();
            String matchingName = this.matching.getType().getName();
            if (this.matching.getType().equals((Object)Matching.Type.TEXT)) {
                matchingName = "";
            }
            if (this.matching.getType() != Matching.Type.EXACT) {
                if (this.matching.isPrefix()) {
                    matchingName = "prefix";
                } else if (this.matching.isSubstring()) {
                    matchingName = "substring";
                } else if (this.matching.isSuffix()) {
                    matchingName = "suffix";
                }
            }
            if (this.type != Type.STRING) {
                matchingName = "";
            }
            fB.name(this.getName()).searchmethod(VsmfieldsConfig.Fieldspec.Searchmethod.Enum.valueOf((String)this.type.getSearchMethod())).arg1(matchingName).fieldtype(this.isAttribute ? VsmfieldsConfig.Fieldspec.Fieldtype.ATTRIBUTE : VsmfieldsConfig.Fieldspec.Fieldtype.INDEX);
            if (this.matching.maxLength() != null) {
                fB.maxlength(this.matching.maxLength().intValue());
            }
            return fB;
        }

        public boolean equals(Object o) {
            if (o.getClass().equals(this.getClass())) {
                StreamingField sf = (StreamingField)o;
                return this.name.equals(sf.name) && this.matching.equals(sf.matching) && this.type.equals(sf.type);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.matching, this.type);
        }

        public static class Type {
            public static Type INT8 = new Type("int8", "INT8");
            public static Type INT16 = new Type("int16", "INT16");
            public static Type INT32 = new Type("int32", "INT32");
            public static Type INT64 = new Type("int64", "INT64");
            public static Type FLOAT16 = new Type("float16", "FLOAT16");
            public static Type FLOAT = new Type("float", "FLOAT");
            public static Type DOUBLE = new Type("double", "DOUBLE");
            public static Type STRING = new Type("string", "AUTOUTF8");
            public static Type BOOL = new Type("bool", "BOOL");
            public static Type UNSEARCHABLESTRING = new Type("string", "NONE");
            public static Type GEO_POSITION = new Type("position", "GEOPOS");
            private String name;
            private String searchMethod;

            private Type(String name, String searchMethod) {
                this.name = name;
                this.searchMethod = searchMethod;
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String getName() {
                return this.name;
            }

            public String getSearchMethod() {
                return this.searchMethod;
            }

            public boolean equals(Object other) {
                if (!(other instanceof Type)) {
                    return false;
                }
                return this.name.equals(((Type)other).name);
            }

            public String toString() {
                return "type: " + this.name;
            }
        }
    }
}

