/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AddExtraFieldsToDocument
extends Processor {
    AddExtraFieldsToDocument(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    private boolean dirtyLegalFieldNameCheck(String fieldName) {
        return !fieldName.contains(".") && !"rankfeatures".equals(fieldName) && !"summaryfeatures".equals(fieldName);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        SDDocumentType document = this.schema.getDocument();
        if (document != null) {
            for (SDField sDField : this.schema.extraFieldList()) {
                this.addSdField(this.schema, document, sDField, validate);
            }
            for (SummaryField summaryField : this.schema.getSummary("default").getSummaryFields().values()) {
                if (!this.dirtyLegalFieldNameCheck(summaryField.getName())) continue;
                this.addSummaryField(this.schema, document, summaryField, validate);
            }
        }
    }

    private void addSdField(Schema schema, SDDocumentType document, SDField field, boolean validate) {
        if (!field.hasIndex() && field.getAttributes().isEmpty()) {
            return;
        }
        for (Attribute atr : field.getAttributes().values()) {
            if (atr.getName().equals(field.getName())) continue;
            this.addField(schema, document, new SDField(document, atr.getName(), atr.getDataType()), validate);
        }
        this.addField(schema, document, field, validate);
    }

    private void addSummaryField(Schema schema, SDDocumentType document, SummaryField field, boolean validate) {
        Field docField = document.getField(field.getName());
        if (docField == null) {
            ImmutableSDField existingField = schema.getField(field.getName());
            if (existingField == null) {
                SDField newField = new SDField(document, field.getName(), field.getDataType(), true);
                newField.setIsExtraField(true);
                document.addField(newField);
            } else if (!existingField.isImportedField()) {
                document.addField(existingField.asField());
            }
        } else if (!docField.getDataType().equals((Object)field.getDataType()) && validate) {
            throw this.newProcessException(schema, field, "Summary field has conflicting type.");
        }
    }

    private void addField(Schema schema, SDDocumentType document, Field field, boolean validate) {
        if (document.getField(field.getName()) != null && document.getField(field.getName()) != field && validate) {
            throw this.newProcessException(schema, field, "Field shadows another.");
        }
        document.addField(field);
    }
}

