/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.SummaryClass;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import java.util.ArrayList;
import java.util.List;

public class Summaries
extends Derived
implements SummaryConfig.Producer {
    private final boolean useV8GeoPositions;
    private List<SummaryClass> summaries = new ArrayList<SummaryClass>(1);

    public Summaries(Schema schema, DeployLogger deployLogger, ModelContext.FeatureFlags featureFlags) {
        this.useV8GeoPositions = featureFlags.useV8GeoPositions();
        this.summaries.add(new SummaryClass(schema, schema.getSummary("default"), deployLogger));
        for (DocumentSummary summary : schema.getSummaries().values()) {
            if (summary.getName().equals("default")) continue;
            this.summaries.add(new SummaryClass(schema, summary, deployLogger));
        }
    }

    @Override
    protected String getDerivedName() {
        return "summary";
    }

    public void getConfig(SummaryConfig.Builder builder) {
        builder.defaultsummaryid(this.summaries.isEmpty() ? -1 : this.summaries.get(0).hashCode());
        builder.usev8geopositions(this.useV8GeoPositions);
        for (SummaryClass summaryClass : this.summaries) {
            builder.classes(summaryClass.getSummaryClassConfig());
        }
    }
}

