/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.TemporarySDDocumentType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class TemporarySDTypeResolver {
    private final DeployLogger deployLogger;
    private final Collection<Schema> toProcess;
    private final List<SDDocumentType> docTypes = new LinkedList<SDDocumentType>();

    public TemporarySDTypeResolver(Collection<Schema> schemas, DeployLogger deployLogger) {
        this.deployLogger = deployLogger;
        this.toProcess = schemas;
    }

    private SDDocumentType findDocType(String name) {
        assert (name != null);
        for (SDDocumentType doc : this.docTypes) {
            if (!doc.getName().equals(name)) continue;
            return doc;
        }
        this.deployLogger.logApplicationPackage(Level.WARNING, "No document type in application matching name: " + name);
        return null;
    }

    public void process() {
        this.docTypes.add(SDDocumentType.VESPA_DOCUMENT);
        for (Schema schema : this.toProcess) {
            if (!schema.hasDocument()) continue;
            this.docTypes.add(schema.getDocument());
        }
        for (SDDocumentType doc : this.docTypes) {
            for (SDDocumentType inherited : doc.getInheritedTypes()) {
                if (!(inherited instanceof TemporarySDDocumentType)) continue;
                SDDocumentType actual = this.findDocType(inherited.getName());
                if (actual != null) {
                    doc.inherit(actual);
                    continue;
                }
                this.deployLogger.logApplicationPackage(Level.WARNING, "Unresolved inherit '" + inherited.getName() + "' for document " + doc.getName());
            }
        }
        for (SDDocumentType doc : this.docTypes) {
            for (SDDocumentType owned : doc.getTypes()) {
                if (owned instanceof TemporarySDDocumentType) {
                    this.deployLogger.logApplicationPackage(Level.WARNING, "Schema '" + doc.getName() + "' owned type '" + owned.getName() + "' is temporary, should not happen");
                    continue;
                }
                for (SDDocumentType inherited : owned.getInheritedTypes()) {
                    if (!(inherited instanceof TemporarySDDocumentType)) continue;
                    SDDocumentType actual = doc.getType(inherited.getName());
                    if (actual != null) {
                        owned.inherit(actual);
                        continue;
                    }
                    this.deployLogger.logApplicationPackage(Level.WARNING, "Unresolved inherit '" + inherited.getName() + "' for type '" + owned.getName() + "' in document " + doc.getName());
                }
            }
        }
    }
}

