/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RankingConstants {
    private final FileRegistry fileRegistry;
    private final Optional<Schema> owner;
    private final Map<String, RankingConstant> constants = new ConcurrentHashMap<String, RankingConstant>();

    public RankingConstants(FileRegistry fileRegistry, Optional<Schema> owner) {
        this.fileRegistry = fileRegistry;
        this.owner = owner;
    }

    public void add(RankingConstant constant) {
        constant.validate();
        constant.register(this.fileRegistry);
        String name = constant.getName();
        RankingConstant prev = this.constants.putIfAbsent(name, constant);
        if (prev != null) {
            throw new IllegalArgumentException("Ranking constant '" + name + "' defined twice");
        }
    }

    public void putIfAbsent(RankingConstant constant) {
        constant.validate();
        constant.register(this.fileRegistry);
        String name = constant.getName();
        this.constants.putIfAbsent(name, constant);
    }

    public void computeIfAbsent(String name, Function<? super String, ? extends RankingConstant> createConstant) {
        this.constants.computeIfAbsent(name, (? super K key) -> {
            RankingConstant constant = (RankingConstant)createConstant.apply((String)key);
            constant.validate();
            constant.register(this.fileRegistry);
            return constant;
        });
    }

    public RankingConstant get(String name) {
        RankingConstant constant = this.constants.get(name);
        if (constant != null) {
            return constant;
        }
        if (this.owner.isPresent() && this.owner.get().inherited().isPresent()) {
            return this.owner.get().inherited().get().rankingConstants().get(name);
        }
        return null;
    }

    public Map<String, RankingConstant> asMap() {
        if (this.owner.isEmpty() || this.owner.get().inherited().isEmpty()) {
            return Collections.unmodifiableMap(this.constants);
        }
        if (this.constants.isEmpty()) {
            return this.owner.get().inherited().get().rankingConstants().asMap();
        }
        HashMap<String, RankingConstant> allConstants = new HashMap<String, RankingConstant>(this.owner.get().inherited().get().rankingConstants().asMap());
        allConstants.putAll(this.constants);
        return Collections.unmodifiableMap(allConstants);
    }
}

