/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.searchdefinition.Application;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.SDParser;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.TokenMgrException;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ApplicationBuilder {
    private final ApplicationPackage applicationPackage;
    private final List<Schema> schemas = new ArrayList<Schema>();
    private final DocumentTypeManager documentTypeManager = new DocumentTypeManager();
    private final RankProfileRegistry rankProfileRegistry;
    private final QueryProfileRegistry queryProfileRegistry;
    private final FileRegistry fileRegistry;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;
    private final boolean documentsOnly;
    private Application application;
    private final Set<Class<? extends Processor>> processorsToSkip = new HashSet<Class<? extends Processor>>();

    public ApplicationBuilder() {
        this(new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public ApplicationBuilder(DeployLogger deployLogger) {
        this(MockApplicationPackage.createEmpty(), deployLogger);
    }

    public ApplicationBuilder(DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(MockApplicationPackage.createEmpty(), deployLogger, rankProfileRegistry);
    }

    public ApplicationBuilder(boolean documentsOnly) {
        this(MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry(), documentsOnly);
    }

    public ApplicationBuilder(ApplicationPackage app, DeployLogger deployLogger) {
        this(app, (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public ApplicationBuilder(ApplicationPackage app, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(app, (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), rankProfileRegistry, new QueryProfileRegistry());
    }

    public ApplicationBuilder(RankProfileRegistry rankProfileRegistry) {
        this(rankProfileRegistry, new QueryProfileRegistry());
    }

    public ApplicationBuilder(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(rankProfileRegistry, queryProfileRegistry, new TestProperties());
    }

    public ApplicationBuilder(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry, ModelContext.Properties properties) {
        this(MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), properties, rankProfileRegistry, queryProfileRegistry);
    }

    public ApplicationBuilder(ApplicationPackage app, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(app, fileRegistry, deployLogger, properties, rankProfileRegistry, queryProfileRegistry, false);
    }

    private ApplicationBuilder(ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry, boolean documentsOnly) {
        this.applicationPackage = applicationPackage;
        this.rankProfileRegistry = rankProfileRegistry;
        this.queryProfileRegistry = queryProfileRegistry;
        this.fileRegistry = fileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.documentsOnly = documentsOnly;
        for (NamedReader reader : applicationPackage.getSchemas()) {
            this.addSchema(reader);
        }
    }

    public Schema addSchemaFile(String fileName) throws IOException, ParseException {
        File file = new File(fileName);
        return this.addSchema(IOUtils.readFile((File)file), file.getAbsoluteFile().getParent());
    }

    private void addSchema(NamedReader reader) {
        try {
            String schemaName = this.addSchema(IOUtils.readAll((Reader)reader), reader.getName()).getName();
            String schemaFileName = ApplicationBuilder.stripSuffix(reader.getName(), ".sd");
            if (!schemaFileName.equals(schemaName)) {
                throw new IllegalArgumentException("The file containing schema '" + schemaName + "' must be named '" + schemaName + ".sd', not " + reader.getName());
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse schema file '" + reader.getName() + "'", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read schema file '" + reader.getName() + "'", e);
        }
        finally {
            ApplicationBuilder.closeIgnoreException(reader.getReader());
        }
    }

    private static String stripSuffix(String readerName, String suffix) {
        if (!readerName.endsWith(suffix)) {
            throw new IllegalArgumentException("Schema '" + readerName + "' does not end with " + suffix);
        }
        return readerName.substring(0, readerName.length() - suffix.length());
    }

    public Schema addSchema(String string) throws ParseException {
        return this.addSchema(string, null);
    }

    private Schema addSchema(String schemaString, String schemaPath) throws ParseException {
        return this.add(this.createSchema(schemaString, schemaPath));
    }

    public Schema add(Schema schema) {
        if (schema.getName() == null) {
            throw new IllegalArgumentException("Schema has no name");
        }
        this.schemas.add(schema);
        return schema;
    }

    private Schema createSchema(String schemaString, String schemaPath) throws ParseException {
        Schema schema = this.parseSchema(schemaString, schemaPath);
        this.addRankProfileFiles(schema, schemaPath);
        return schema;
    }

    private Schema parseSchema(String schemaString, String schemaPath) throws ParseException {
        SimpleCharStream stream = new SimpleCharStream(schemaString);
        try {
            return new SDParser(stream, this.applicationPackage, this.fileRegistry, this.deployLogger, this.properties, this.rankProfileRegistry, this.documentsOnly).schema(this.documentTypeManager, schemaPath);
        }
        catch (TokenMgrException e) {
            throw new ParseException("Unknown symbol: " + e.getMessage());
        }
        catch (ParseException pe) {
            throw new ParseException(stream.formatException(Exceptions.toMessageString((Throwable)pe)));
        }
    }

    private void addRankProfileFiles(Schema schema, String schemaPath) {
        if (this.applicationPackage == null || schemaPath == null) {
            return;
        }
        Path rankProfilePath = Path.fromString((String)schemaPath).append(schema.getName());
        for (NamedReader reader : this.applicationPackage.getFiles(rankProfilePath, ".profile")) {
            this.parseRankProfile(reader, schema);
        }
    }

    private void parseRankProfile(NamedReader reader, Schema schema) {
        try {
            SimpleCharStream stream = new SimpleCharStream(IOUtils.readAll((Reader)reader.getReader()));
            try {
                new SDParser(stream, this.applicationPackage, this.fileRegistry, this.deployLogger, this.properties, this.rankProfileRegistry, this.documentsOnly).rankProfile(schema);
            }
            catch (TokenMgrException e) {
                throw new ParseException("Unknown symbol: " + e.getMessage());
            }
            catch (ParseException pe) {
                throw new ParseException(stream.formatException(Exceptions.toMessageString((Throwable)pe)));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read rank profile " + reader.getName(), e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse rank profile " + reader.getName(), e);
        }
    }

    public Application build(boolean validate) {
        if (this.application != null) {
            throw new IllegalStateException("Application already built");
        }
        this.application = new Application(this.applicationPackage, this.schemas, this.rankProfileRegistry, new QueryProfiles(this.queryProfileRegistry, this.deployLogger), this.properties, this.documentsOnly, validate, this.processorsToSkip, this.deployLogger);
        return this.application;
    }

    public Set<Class<? extends Processor>> processorsToSkip() {
        return this.processorsToSkip;
    }

    public Schema getSchema() {
        if (this.application == null) {
            throw new IllegalStateException("Application not built");
        }
        if (this.application.schemas().size() != 1) {
            throw new IllegalStateException("This call only works if we have 1 schema. Schemas: " + this.application.schemas().values());
        }
        return this.application.schemas().values().stream().findAny().get();
    }

    public DocumentModel getModel() {
        return this.application.documentModel();
    }

    public Schema getSchema(String name) {
        if (this.application == null) {
            throw new IllegalStateException("Application not built");
        }
        if (name == null) {
            return this.getSchema();
        }
        return this.application.schemas().get(name);
    }

    public Application application() {
        return this.application;
    }

    public List<Schema> getSchemaList() {
        return new ArrayList<Schema>(this.application.schemas().values());
    }

    public static ApplicationBuilder createFromString(String sd) throws ParseException {
        return ApplicationBuilder.createFromString(sd, (DeployLogger)new BaseDeployLogger());
    }

    public static ApplicationBuilder createFromString(String sd, DeployLogger logger) throws ParseException {
        ApplicationBuilder builder = new ApplicationBuilder(logger);
        builder.addSchema(sd);
        builder.build(true);
        return builder;
    }

    public static ApplicationBuilder createFromStrings(DeployLogger logger, String ... schemas) throws ParseException {
        ApplicationBuilder builder = new ApplicationBuilder(logger);
        for (String schema : schemas) {
            builder.addSchema(schema);
        }
        builder.build(true);
        return builder;
    }

    public static ApplicationBuilder createFromFile(String fileName) throws IOException, ParseException {
        return ApplicationBuilder.createFromFile(fileName, (DeployLogger)new BaseDeployLogger());
    }

    public static ApplicationBuilder createFromFiles(Collection<String> fileNames) throws IOException, ParseException {
        return ApplicationBuilder.createFromFiles(fileNames, (DeployLogger)new BaseDeployLogger());
    }

    public static ApplicationBuilder createFromFile(String fileName, DeployLogger logger) throws IOException, ParseException {
        return ApplicationBuilder.createFromFile(fileName, logger, new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static ApplicationBuilder createFromFiles(Collection<String> fileNames, DeployLogger logger) throws IOException, ParseException {
        return ApplicationBuilder.createFromFiles(fileNames, (FileRegistry)new MockFileRegistry(), logger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static ApplicationBuilder createFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        return ApplicationBuilder.createFromFiles(Collections.singletonList(fileName), (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), rankProfileRegistry, queryprofileRegistry);
    }

    private static ApplicationBuilder createFromFiles(Collection<String> fileNames, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        ApplicationBuilder builder = new ApplicationBuilder(MockApplicationPackage.createEmpty(), fileRegistry, deployLogger, properties, rankProfileRegistry, queryprofileRegistry);
        for (String fileName : fileNames) {
            builder.addSchemaFile(fileName);
        }
        builder.build(true);
        return builder;
    }

    public static ApplicationBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties) throws IOException, ParseException {
        return ApplicationBuilder.createFromDirectory(dir, fileRegistry, logger, properties, new RankProfileRegistry());
    }

    public static ApplicationBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry) throws IOException, ParseException {
        return ApplicationBuilder.createFromDirectory(dir, fileRegistry, logger, properties, rankProfileRegistry, ApplicationBuilder.createQueryProfileRegistryFromDirectory(dir));
    }

    private static ApplicationBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return ApplicationBuilder.createFromDirectory(dir, MockApplicationPackage.fromSearchDefinitionAndRootDirectory(dir), fileRegistry, logger, properties, rankProfileRegistry, queryProfileRegistry);
    }

    private static ApplicationBuilder createFromDirectory(String dir, ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        ApplicationBuilder builder = new ApplicationBuilder(applicationPackage, fileRegistry, deployLogger, properties, rankProfileRegistry, queryProfileRegistry);
        Iterator i = Files.list(new File(dir).toPath()).filter(p -> p.getFileName().toString().endsWith(".sd")).iterator();
        while (i.hasNext()) {
            builder.addSchemaFile(((java.nio.file.Path)i.next()).toString());
        }
        builder.build(true);
        return builder;
    }

    private static QueryProfileRegistry createQueryProfileRegistryFromDirectory(String dir) {
        File queryProfilesDir = new File(dir, "query-profiles");
        if (!queryProfilesDir.exists()) {
            return new QueryProfileRegistry();
        }
        return new QueryProfileXMLReader().read(queryProfilesDir.toString());
    }

    public static Schema buildFromFile(String fileName) throws IOException, ParseException {
        return ApplicationBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public static Schema buildFromFile(String fileName, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return ApplicationBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), rankProfileRegistry, queryProfileRegistry);
    }

    public static Schema buildFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return ApplicationBuilder.createFromFile(fileName, deployLogger, rankProfileRegistry, queryProfileRegistry).getSchema();
    }

    public static ApplicationBuilder createFromRawSchema(Schema rawSchema, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        ApplicationBuilder builder = new ApplicationBuilder(rankProfileRegistry, queryProfileRegistry);
        builder.add(rawSchema);
        builder.build(true);
        return builder;
    }

    public static Schema buildFromRawSchema(Schema rawSchema, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        return ApplicationBuilder.createFromRawSchema(rawSchema, rankProfileRegistry, queryProfileRegistry).getSchema();
    }

    public RankProfileRegistry getRankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public QueryProfileRegistry getQueryProfileRegistry() {
        return this.queryProfileRegistry;
    }

    public ModelContext.Properties getProperties() {
        return this.properties;
    }

    public DeployLogger getDeployLogger() {
        return this.deployLogger;
    }

    private static void closeIgnoreException(Reader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

